/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.workflow.impl;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.internal.AbstractAgentInvocationHandler;
import dev.langchain4j.agentic.internal.AbstractService;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.workflow.ConditionalAgentService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ConditionalAgentServiceImpl<T>
extends AbstractService<T, ConditionalAgentService<T>>
implements ConditionalAgentService<T> {
    private final List<ConditionalAgent> conditionalAgents = new ArrayList<ConditionalAgent>();

    private ConditionalAgentServiceImpl(Class<T> agentServiceClass, Method agenticMethod) {
        super(agentServiceClass, agenticMethod);
    }

    @Override
    public T build() {
        return (T)Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, AgentSpecification.class, AgenticScopeOwner.class}, (InvocationHandler)new ConditionialInvocationHandler());
    }

    public static ConditionalAgentServiceImpl<UntypedAgent> builder() {
        return new ConditionalAgentServiceImpl<UntypedAgent>(UntypedAgent.class, null);
    }

    public static <T> ConditionalAgentServiceImpl<T> builder(Class<T> agentServiceClass) {
        return new ConditionalAgentServiceImpl<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass, false));
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(Object ... agents) {
        return this.subAgents(agenticScope -> true, agents);
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(Predicate<AgenticScope> condition, Object ... agents) {
        return this.subAgents((Predicate)condition, (List)AgentUtil.agentsToExecutors(agents));
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(List<AgentExecutor> agentExecutors) {
        return this.subAgents(agenticScope -> true, (List)agentExecutors);
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgents(Predicate<AgenticScope> condition, List<AgentExecutor> agentExecutors) {
        this.conditionalAgents.add(new ConditionalAgent(condition, agentExecutors));
        return this;
    }

    @Override
    public ConditionalAgentServiceImpl<T> subAgent(Predicate<AgenticScope> condition, AgentExecutor agentExecutor) {
        this.conditionalAgents.add(new ConditionalAgent(condition, List.of(agentExecutor)));
        return this;
    }

    private class ConditionialInvocationHandler
    extends AbstractAgentInvocationHandler {
        private ConditionialInvocationHandler() {
            super(ConditionalAgentServiceImpl.this);
        }

        private ConditionialInvocationHandler(DefaultAgenticScope agenticScope) {
            super(ConditionalAgentServiceImpl.this, agenticScope);
        }

        @Override
        protected Object doAgentAction(DefaultAgenticScope agenticScope) {
            for (ConditionalAgent conditionalAgent : ConditionalAgentServiceImpl.this.conditionalAgents) {
                if (!conditionalAgent.condition.test(agenticScope)) continue;
                for (AgentExecutor agentExecutor : conditionalAgent.agentExecutors) {
                    agentExecutor.execute(agenticScope);
                }
            }
            return this.result(agenticScope, ConditionalAgentServiceImpl.this.output.apply(agenticScope));
        }

        @Override
        protected InvocationHandler createSubAgentWithAgenticScope(DefaultAgenticScope agenticScope) {
            return new ConditionialInvocationHandler(agenticScope);
        }
    }

    private record ConditionalAgent(Predicate<AgenticScope> condition, List<AgentExecutor> agentExecutors) {
    }
}

