/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.supervisor;

import dev.langchain4j.agentic.internal.AbstractAgentInvocationHandler;
import dev.langchain4j.agentic.internal.AbstractService;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.internal.Context;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.AgenticScopeAccess;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.supervisor.AgentInvocation;
import dev.langchain4j.agentic.supervisor.PlannerAgent;
import dev.langchain4j.agentic.supervisor.ResponseAgent;
import dev.langchain4j.agentic.supervisor.ResponseScore;
import dev.langchain4j.agentic.supervisor.SupervisorAgent;
import dev.langchain4j.agentic.supervisor.SupervisorAgentService;
import dev.langchain4j.agentic.supervisor.SupervisorContextStrategy;
import dev.langchain4j.agentic.supervisor.SupervisorResponseStrategy;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorAgentServiceImpl<T>
extends AbstractService<T, SupervisorAgentServiceImpl<T>>
implements SupervisorAgentService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorAgentServiceImpl.class);
    public static final String SUPERVISOR_CONTEXT_KEY = "supervisorContext";
    private ChatModel chatModel;
    private int maxAgentsInvocations = 10;
    private ResponseAgent responseAgent;
    private final Map<String, AgentExecutor> agents = new HashMap<String, AgentExecutor>();
    private String agentsList;
    private SupervisorContextStrategy contextStrategy = SupervisorContextStrategy.CHAT_MEMORY;
    private SupervisorResponseStrategy responseStrategy = SupervisorResponseStrategy.LAST;
    private Function<AgenticScope, String> requestGenerator;
    private String supervisorContext;

    private SupervisorAgentServiceImpl(Class<T> agentServiceClass, Method agenticMethod) {
        super(agentServiceClass, agenticMethod);
    }

    @Override
    public T build() {
        if (this.responseStrategy == SupervisorResponseStrategy.SCORED) {
            this.responseAgent = (ResponseAgent)AiServices.builder(ResponseAgent.class).chatModel(this.chatModel).build();
        }
        if (this.supervisorContext != null) {
            this.beforeCall(agenticScope -> {
                if (!agenticScope.hasState(SUPERVISOR_CONTEXT_KEY)) {
                    agenticScope.writeState(SUPERVISOR_CONTEXT_KEY, this.supervisorContext);
                }
            });
        }
        return this.build(null);
    }

    T build(DefaultAgenticScope agenticScope) {
        return (T)Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, AgentSpecification.class, AgenticScopeOwner.class, AgenticScopeAccess.class}, (InvocationHandler)new SupervisorInvocationHandler(this.buildPlannerAgent(agenticScope), agenticScope));
    }

    private PlannerAgent buildPlannerAgent(AgenticScope agenticScope) {
        if (agenticScope == null && this.isAgenticScopeDependent()) {
            return null;
        }
        AiServices builder = AiServices.builder(PlannerAgent.class).chatModel(this.chatModel);
        switch (this.contextStrategy) {
            case CHAT_MEMORY: {
                builder.chatMemoryProvider(memoryId -> MessageWindowChatMemory.withMaxMessages((int)20));
                break;
            }
            case SUMMARIZATION: {
                builder.chatMemoryProvider(memoryId -> MessageWindowChatMemory.withMaxMessages((int)2)).chatRequestTransformer((BiFunction)new Context.Summarizer(agenticScope, this.chatModel, new String[0]));
                break;
            }
            case CHAT_MEMORY_AND_SUMMARIZATION: {
                builder.chatMemoryProvider(memoryId -> MessageWindowChatMemory.withMaxMessages((int)20)).chatRequestTransformer((BiFunction)new Context.Summarizer(agenticScope, this.chatModel, new String[0]));
            }
        }
        return (PlannerAgent)builder.build();
    }

    private boolean isAgenticScopeDependent() {
        return this.contextStrategy != SupervisorContextStrategy.CHAT_MEMORY;
    }

    public static SupervisorAgentService<SupervisorAgent> builder() {
        return new SupervisorAgentServiceImpl<SupervisorAgent>(SupervisorAgent.class, null);
    }

    public static <T> SupervisorAgentService<T> builder(Class<T> agentServiceClass) {
        return new SupervisorAgentServiceImpl<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass, false));
    }

    @Override
    public SupervisorAgentServiceImpl<T> chatModel(ChatModel chatModel) {
        this.chatModel = chatModel;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> requestGenerator(Function<AgenticScope, String> requestGenerator) {
        this.requestGenerator = requestGenerator;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> contextGenerationStrategy(SupervisorContextStrategy contextStrategy) {
        this.contextStrategy = contextStrategy;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> responseStrategy(SupervisorResponseStrategy responseStrategy) {
        this.responseStrategy = responseStrategy;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> supervisorContext(String supervisorContext) {
        this.supervisorContext = supervisorContext;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> subAgents(List<AgentExecutor> agentExecutors) {
        for (AgentExecutor agentExecutor : agentExecutors) {
            if (!agentExecutor.agentInvoker().description().isEmpty()) {
                this.agents.put(agentExecutor.agentName(), agentExecutor);
                continue;
            }
            throw new IllegalArgumentException("Agent '" + agentExecutor.agentName() + "' must have a non-empty description in order to be used by the supervisor agent.");
        }
        this.agentsList = this.agents.values().stream().map(AgentExecutor::agentInvoker).map(AgentInvoker::toCard).collect(Collectors.joining(", "));
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> maxAgentsInvocations(int maxAgentsInvocations) {
        this.maxAgentsInvocations = maxAgentsInvocations;
        return this;
    }

    private class SupervisorInvocationHandler
    extends AbstractAgentInvocationHandler {
        private final PlannerAgent plannerAgent;

        public SupervisorInvocationHandler(PlannerAgent plannerAgent, DefaultAgenticScope agenticScope) {
            super(SupervisorAgentServiceImpl.this, agenticScope);
            this.plannerAgent = plannerAgent;
        }

        @Override
        protected Object doAgentAction(DefaultAgenticScope agenticScope) {
            String request = SupervisorAgentServiceImpl.this.requestGenerator != null ? SupervisorAgentServiceImpl.this.requestGenerator.apply(agenticScope) : agenticScope.readState("request", "");
            String lastResponse = "";
            Object memoryId = agenticScope.memoryId();
            String result = null;
            for (int loopCount = 0; loopCount < SupervisorAgentServiceImpl.this.maxAgentsInvocations; ++loopCount) {
                PlannerAgent planner = SupervisorAgentServiceImpl.this.isAgenticScopeDependent() ? agenticScope.getOrCreateAgent(this.agentId(), SupervisorAgentServiceImpl.this::buildPlannerAgent) : this.plannerAgent;
                String supervisorContext = agenticScope.readState(SupervisorAgentServiceImpl.SUPERVISOR_CONTEXT_KEY, "");
                AgentInvocation agentInvocation = planner.plan(memoryId, SupervisorAgentServiceImpl.this.agentsList, request, lastResponse, supervisorContext);
                LOG.info("Agent Invocation: {}", (Object)agentInvocation);
                if (agentInvocation.getAgentName().equalsIgnoreCase("done")) {
                    if (SupervisorAgentServiceImpl.this.hasOutputFunction()) {
                        result = SupervisorAgentServiceImpl.this.output.apply(agenticScope);
                        break;
                    }
                    String doneResponse = agentInvocation.getArguments().get("response");
                    result = this.response(request, lastResponse, doneResponse);
                    break;
                }
                String agentName = agentInvocation.getAgentName();
                AgentExecutor agentExec = SupervisorAgentServiceImpl.this.agents.get(agentName);
                if (agentExec == null) {
                    throw new IllegalStateException("No agent found with name: " + agentName);
                }
                AgentInvoker agentSpec = agentExec.agentInvoker();
                if (agentSpec == null) {
                    throw new IllegalStateException("No specification found for agent: " + agentName);
                }
                agentInvocation.getArguments().forEach(agenticScope::writeState);
                lastResponse = agentExec.execute(agenticScope).toString();
            }
            if (result == null) {
                result = lastResponse;
            }
            if (this.outputName != null) {
                agenticScope.writeState(this.outputName, result);
            }
            return result;
        }

        private String response(String request, String lastResponse, String doneResponse) {
            if (doneResponse == null) {
                return lastResponse;
            }
            return switch (SupervisorAgentServiceImpl.this.responseStrategy) {
                default -> throw new IncompatibleClassChangeError();
                case SupervisorResponseStrategy.LAST -> lastResponse;
                case SupervisorResponseStrategy.SUMMARY -> doneResponse;
                case SupervisorResponseStrategy.SCORED -> {
                    ResponseScore score = SupervisorAgentServiceImpl.this.responseAgent.scoreResponses(request, lastResponse, doneResponse);
                    LOG.info("Response scores: {}", (Object)score);
                    if (score.getScore2() > score.getScore1()) {
                        yield doneResponse;
                    }
                    yield lastResponse;
                }
            };
        }

        @Override
        protected InvocationHandler createSubAgentWithAgenticScope(DefaultAgenticScope agenticScope) {
            return new SupervisorInvocationHandler(this.plannerAgent, agenticScope);
        }

        private String agentId() {
            return this.outputName + "@Supervisor";
        }
    }
}

