/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.scope;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import dev.langchain4j.Internal;
import dev.langchain4j.agentic.internal.AgentInvocation;
import dev.langchain4j.agentic.scope.AgenticScopeJsonCodec;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.JacksonChatMessageJsonCodec;
import java.util.Collection;

@Internal
class JacksonAgenticScopeJsonCodec
implements AgenticScopeJsonCodec {
    private static final ObjectMapper SERIALIZER_MAPPER = JacksonAgenticScopeJsonCodec.agenticScopeJsonSerializer();
    private static final ObjectMapper DESERIALIZER_MAPPER = JacksonAgenticScopeJsonCodec.agenticScopeJsonMapperBuilder().build();

    JacksonAgenticScopeJsonCodec() {
    }

    static JsonMapper.Builder agenticScopeJsonMapperBuilder() {
        return (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JacksonChatMessageJsonCodec.chatMessageJsonMapperBuilder().addMixIn(DefaultAgenticScope.class, AgenticScopeMixin.class)).addMixIn(DefaultAgenticScope.AgentMessage.class, AgentMessageMixin.class)).addMixIn(AgentInvocation.class, AgentInvocationMixin.class);
    }

    static ObjectMapper agenticScopeJsonSerializer() {
        ObjectMapper mapper = JacksonAgenticScopeJsonCodec.agenticScopeJsonMapperBuilder().build();
        mapper.activateDefaultTyping((PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).build(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);
        CustomTypeResolverBuilder typeResolverBuilder = new CustomTypeResolverBuilder();
        typeResolverBuilder.init(JsonTypeInfo.Id.CLASS, null);
        typeResolverBuilder.inclusion(JsonTypeInfo.As.WRAPPER_OBJECT);
        mapper.setDefaultTyping((TypeResolverBuilder)typeResolverBuilder);
        return mapper;
    }

    @Override
    public DefaultAgenticScope fromJson(String json) {
        try {
            return (DefaultAgenticScope)DESERIALIZER_MAPPER.readValue(json, DefaultAgenticScope.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize AgenticScope from JSON", e);
        }
    }

    @Override
    public String toJson(DefaultAgenticScope agenticScope) {
        try {
            return SERIALIZER_MAPPER.writeValueAsString((Object)agenticScope);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize AgenticScope to JSON", e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static abstract class AgenticScopeMixin {
        @JsonCreator
        public AgenticScopeMixin(@JsonProperty(value="memoryId") Object memoryId, @JsonProperty(value="kind") DefaultAgenticScope.Kind kind) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static abstract class AgentMessageMixin {
        @JsonCreator
        public AgentMessageMixin(@JsonProperty(value="agentName") String agentName, @JsonProperty(value="message") ChatMessage message) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static abstract class AgentInvocationMixin {
        @JsonCreator
        public AgentInvocationMixin(@JsonProperty(value="agentName") String agentName, @JsonProperty(value="input") Object[] input, @JsonProperty(value="output") Object output) {
        }
    }

    public static class CustomTypeResolverBuilder
    extends StdTypeResolverBuilder {
        protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
            return new CustomTypeIdResolver();
        }
    }

    public static class CustomTypeIdResolver
    extends TypeIdResolverBase {
        public String idFromValue(Object value) {
            return this.idFromValueAndType(value, value.getClass());
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            String className = suggestedType.getName();
            return this.isBuiltInType(className) ? null : className;
        }

        private boolean isBuiltInType(String className) {
            return className.startsWith("java.") || className.startsWith("[Ljava.") || className.startsWith("dev.langchain4j.data.message.") || className.startsWith("dev.langchain4j.agentic.scope.") || className.startsWith("dev.langchain4j.agentic.internal.");
        }

        public JavaType typeFromId(DatabindContext context, String id) {
            if (id == null) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(id);
                return context.constructType(clazz);
            }
            catch (ClassNotFoundException e) {
                if (id.equals("id")) {
                    return context.constructType(String.class);
                }
                return null;
            }
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.CLASS;
        }
    }
}

