/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.Agent;
import dev.langchain4j.agentic.agent.MissingArgumentException;
import dev.langchain4j.agentic.internal.A2AService;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentSpecsProvider;
import dev.langchain4j.agentic.internal.MethodAgentInvoker;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.service.MemoryId;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class AgentUtil {
    private static final String MEMORY_ID_ARG_NAME = "@MemoryId";
    private static final String AGENTIC_SCOPE_ARG_NAME = "@AgenticScope";

    private AgentUtil() {
    }

    public static List<AgentExecutor> agentsToExecutors(Object ... agents) {
        return Stream.of(agents).map(AgentUtil::agentToExecutor).toList();
    }

    public static AgentExecutor agentToExecutor(Object agent) {
        AgentInvoker agentInvoker;
        String description;
        if (agent instanceof AgentSpecification) {
            AgentSpecification agentSpecification = (AgentSpecification)agent;
            return AgentUtil.agentToExecutor(agentSpecification);
        }
        Method agenticMethod = AgentUtil.validateAgentClass(agent.getClass());
        Agent annotation = agenticMethod.getAnnotation(Agent.class);
        String name = Utils.isNullOrBlank((String)annotation.name()) ? agenticMethod.getName() : annotation.name();
        String string = description = Utils.isNullOrBlank((String)annotation.description()) ? annotation.value() : annotation.description();
        if (agent instanceof AgentSpecsProvider) {
            AgentSpecsProvider spec = (AgentSpecsProvider)agent;
            agentInvoker = new MethodAgentInvoker(agenticMethod, name, spec.description(), spec.outputName(), List.of(new AgentArgument(agenticMethod.getParameterTypes()[0], spec.inputName())));
        } else {
            agentInvoker = AgentInvoker.fromMethodAndSpec(agenticMethod, name, description, annotation.outputName());
        }
        AgentInvoker agentInvoker2 = agentInvoker;
        return new AgentExecutor(agentInvoker2, agent);
    }

    public static AgentExecutor agentToExecutor(AgentSpecification agent) {
        for (Method method : agent.getClass().getMethods()) {
            Optional<AgentExecutor> executor;
            Optional<AgentExecutor> optional = executor = A2AService.get().isPresent() ? A2AService.get().methodToAgentExecutor(agent, method) : AgentUtil.methodToAgentExecutor(agent, method);
            if (!executor.isPresent()) continue;
            return executor.get();
        }
        throw new IllegalArgumentException("Agent executor not found");
    }

    public static Optional<Method> getAnnotatedMethodOnClass(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getMethods()).filter(m -> m.isAnnotationPresent(annotation)).findFirst();
    }

    private static Optional<AgentExecutor> methodToAgentExecutor(AgentSpecification agent, Method method) {
        return Utils.getAnnotatedMethod((Method)method, Agent.class).map(agentMethod -> new AgentExecutor(AgentInvoker.fromMethod(agent, agentMethod), agent));
    }

    public static Object[] methodInvocationArguments(AgenticScope agenticScope, Method method) {
        return AgentUtil.methodInvocationArguments(agenticScope, AgentUtil.argumentsFromMethod(method));
    }

    static List<AgentArgument> argumentsFromMethod(Method method) {
        return Stream.of(method.getParameters()).map(p -> new AgentArgument(p.getType(), AgentUtil.parameterName(p))).toList();
    }

    private static String parameterName(Parameter p) {
        if (p.getAnnotation(MemoryId.class) != null) {
            return MEMORY_ID_ARG_NAME;
        }
        if (AgenticScope.class.isAssignableFrom(p.getType())) {
            return AGENTIC_SCOPE_ARG_NAME;
        }
        return AgentInvoker.parameterName(p);
    }

    public static Object[] methodInvocationArguments(AgenticScope agenticScope, List<AgentArgument> agentArguments) throws MissingArgumentException {
        Object[] invocationArgs = new Object[agentArguments.size()];
        int i = 0;
        for (AgentArgument arg : agentArguments) {
            String argName = arg.name();
            if (argName.equals(MEMORY_ID_ARG_NAME)) {
                invocationArgs[i++] = agenticScope.memoryId();
                continue;
            }
            if (argName.equals(AGENTIC_SCOPE_ARG_NAME)) {
                invocationArgs[i++] = agenticScope;
                continue;
            }
            invocationArgs[i++] = AgentUtil.argumentFromAgenticScope(agenticScope, arg.type(), argName);
        }
        return invocationArgs;
    }

    public static Object argumentFromAgenticScope(AgenticScope agenticScope, Class<?> argType, String argName) {
        Object argValue = agenticScope.readState(argName);
        if (argValue == null) {
            throw new MissingArgumentException(argName);
        }
        Object parsedArgument = AgentUtil.parseArgument(argValue, argType);
        if (argValue != parsedArgument) {
            agenticScope.writeState(argName, parsedArgument);
        }
        return parsedArgument;
    }

    static Object parseArgument(Object argValue, Class<?> type) {
        if (argValue instanceof String) {
            String s = (String)argValue;
            return switch (type.getName()) {
                case "java.lang.String" -> s;
                case "int", "java.lang.Integer" -> Integer.parseInt(s);
                case "long", "java.lang.Long" -> Long.parseLong(s);
                case "double", "java.lang.Double" -> Double.parseDouble(s);
                case "float", "java.lang.Float" -> Float.valueOf(Float.parseFloat(s));
                case "boolean", "java.lang.Boolean" -> Boolean.parseBoolean(s);
                default -> throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
            };
        }
        return argValue;
    }

    public static Method validateAgentClass(Class<?> agentServiceClass) {
        return AgentUtil.validateAgentClass(agentServiceClass, true);
    }

    public static Method validateAgentClass(Class<?> agentServiceClass, boolean failOnMissingAnnotation) {
        Method agentMethod = null;
        for (Method method : agentServiceClass.getMethods()) {
            if (!method.isAnnotationPresent(Agent.class)) continue;
            if (agentMethod != null) {
                throw new IllegalArgumentException("Multiple agent methods found in class: " + agentServiceClass.getName());
            }
            agentMethod = method;
        }
        if (agentMethod == null && failOnMissingAnnotation) {
            throw new IllegalArgumentException("No agent method found in class: " + agentServiceClass.getName());
        }
        return agentMethod;
    }

    public record AgentArgument(Class<?> type, String name) {
    }
}

