/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;

public record AgentExecutor(AgentInvoker agentInvoker, Object agent) {
    public String agentName() {
        return this.agentInvoker.name();
    }

    public Object execute(DefaultAgenticScope agenticScope) {
        Object object;
        Object object2 = this.agent;
        if (object2 instanceof AgenticScopeOwner) {
            AgenticScopeOwner co = (AgenticScopeOwner)object2;
            object = co.withAgenticScope(agenticScope);
        } else {
            object = this.agent;
        }
        Object invokedAgent = object;
        try {
            return this.internalExecute(agenticScope, invokedAgent);
        }
        catch (AgentInvocationException e) {
            ErrorRecoveryResult recoveryResult = agenticScope.handleError(this.agentInvoker.name(), e);
            return switch (recoveryResult.type()) {
                default -> throw new IncompatibleClassChangeError();
                case ErrorRecoveryResult.Type.THROW_EXCEPTION -> throw e;
                case ErrorRecoveryResult.Type.RETRY -> this.internalExecute(agenticScope, invokedAgent);
                case ErrorRecoveryResult.Type.RETURN_RESULT -> recoveryResult.result();
            };
        }
    }

    private Object internalExecute(DefaultAgenticScope agenticScope, Object invokedAgent) {
        Object[] args = this.agentInvoker.toInvocationArguments(agenticScope);
        Object response = this.agentInvoker.invoke(invokedAgent, args);
        String outputName = this.agentInvoker.outputName();
        if (outputName != null && !outputName.isBlank()) {
            agenticScope.writeState(outputName, response);
        }
        agenticScope.registerAgentCall(this.agentInvoker.name(), invokedAgent, args, response);
        return response;
    }
}

