/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.agent;

import dev.langchain4j.agentic.agent.AgentBuilder;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class AgentInvocationHandler
implements InvocationHandler {
    private final AiServiceContext context;
    private final AgentBuilder<?> builder;
    private final Object agent;
    private final boolean agenticScopeDependent;

    AgentInvocationHandler(AiServiceContext context, Object agent, AgentBuilder<?> builder, boolean agenticScopeDependent) {
        this.context = context;
        this.agent = agent;
        this.builder = builder;
        this.agenticScopeDependent = agenticScopeDependent;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if (method.getDeclaringClass() == AgenticScopeOwner.class) {
            return switch (method.getName()) {
                case "withAgenticScope" -> {
                    if (this.agenticScopeDependent) {
                        yield ((DefaultAgenticScope)args[0]).getOrCreateAgent(this.builder.agentId(), this.builder::build);
                    }
                    yield proxy;
                }
                case "registry" -> throw new UnsupportedOperationException("AgenticScopeOwner's registry method can be used only on the root agent of an agentic system.");
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeOwner class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == ChatMemoryAccess.class) {
            return switch (method.getName()) {
                case "getChatMemory" -> {
                    if (this.context.hasChatMemory()) {
                        yield this.context.chatMemoryService.getChatMemory(args[0]);
                    }
                    yield null;
                }
                case "evictChatMemory" -> this.context.hasChatMemory() && this.context.chatMemoryService.evictChatMemory(args[0]) != null;
                default -> throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgentSpecification.class) {
            switch (method.getName()) {
                case "outputName": {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + method.getName());
                }
            }
            return this.builder.outputName;
        }
        return method.invoke(this.agent, args);
    }
}

