/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.observability;

import dev.langchain4j.agentic.observability.AgentInvocationError;
import dev.langchain4j.agentic.observability.AgentListener;
import dev.langchain4j.agentic.observability.AgentRequest;
import dev.langchain4j.agentic.observability.AgentResponse;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.scope.AgenticScope;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerNotifierUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerNotifierUtil.class);

    private ListenerNotifierUtil() {
    }

    public static void beforeAgentInvocation(AgentListener listener, AgenticScope agenticScope, AgentInstance agent, Map<String, Object> inputs) {
        if (listener != null) {
            try {
                listener.beforeAgentInvocation(new AgentRequest(agenticScope, agent, inputs));
            }
            catch (Exception e) {
                LOG.error("beforeAgentInvocation listener for agent " + agent.name() + " failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void afterAgentInvocation(AgentListener listener, AgenticScope agenticScope, AgentInstance agent, Map<String, Object> inputs, Object output) {
        if (listener != null) {
            try {
                listener.afterAgentInvocation(new AgentResponse(agenticScope, agent, inputs, output));
            }
            catch (Exception e) {
                LOG.error("afterAgentInvocation listener for agent " + agent.name() + " failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void agentError(AgentListener listener, AgenticScope agenticScope, AgentInstance agent, Map<String, Object> inputs, Throwable error) {
        if (listener != null) {
            try {
                listener.onAgentInvocationError(new AgentInvocationError(agenticScope, agent, inputs, error));
            }
            catch (Exception e) {
                LOG.error("agentError listener for agent " + agent.name() + " failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void afterAgenticScopeCreated(AgentListener listener, AgenticScope agenticScope) {
        if (listener != null) {
            try {
                listener.afterAgenticScopeCreated(agenticScope);
            }
            catch (Exception e) {
                LOG.error("afterAgenticScopeCreated listener failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void beforeAgenticScopeDestroyed(AgentListener listener, AgenticScope agenticScope) {
        if (listener != null) {
            try {
                listener.beforeAgenticScopeDestroyed(agenticScope);
            }
            catch (Exception e) {
                LOG.error("beforeAgenticScopeDestroyed listener failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

