/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.observability;

import dev.langchain4j.agentic.observability.AgentInvocationError;
import dev.langchain4j.agentic.observability.AgentListener;
import dev.langchain4j.agentic.observability.AgentRequest;
import dev.langchain4j.agentic.observability.AgentResponse;
import dev.langchain4j.agentic.observability.MonitoredExecution;
import dev.langchain4j.agentic.scope.AgenticScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AgentMonitor
implements AgentListener {
    private final Map<Object, List<MonitoredExecution>> successfulExecutions = new ConcurrentHashMap<Object, List<MonitoredExecution>>();
    private final Map<Object, List<MonitoredExecution>> failedExecutions = new ConcurrentHashMap<Object, List<MonitoredExecution>>();
    private final Map<Object, MonitoredExecution> ongoingExecutions = new ConcurrentHashMap<Object, MonitoredExecution>();

    @Override
    public void beforeAgentInvocation(AgentRequest agentRequest) {
        Object memoryId = agentRequest.agenticScope().memoryId();
        MonitoredExecution currentExecution = this.ongoingExecutions.get(memoryId);
        if (currentExecution == null) {
            currentExecution = new MonitoredExecution(agentRequest);
            this.ongoingExecutions.put(memoryId, currentExecution);
        } else {
            currentExecution.beforeAgentInvocation(agentRequest);
        }
    }

    @Override
    public void afterAgentInvocation(AgentResponse agentResponse) {
        Object memoryId = agentResponse.agenticScope().memoryId();
        MonitoredExecution execution = this.ongoingExecutions.get(memoryId);
        execution.afterAgentInvocation(agentResponse);
        if (execution.done()) {
            this.ongoingExecutions.remove(memoryId);
            this.successfulExecutions.computeIfAbsent(memoryId, k -> new ArrayList()).add(execution);
        }
    }

    @Override
    public void onAgentInvocationError(AgentInvocationError agentInvocationError) {
        Object memoryId = agentInvocationError.agenticScope().memoryId();
        MonitoredExecution execution = this.ongoingExecutions.remove(memoryId);
        if (execution != null) {
            execution.onAgentInvocationError(agentInvocationError);
            this.failedExecutions.computeIfAbsent(memoryId, k -> new ArrayList()).add(execution);
        }
    }

    @Override
    public boolean inheritedBySubagents() {
        return true;
    }

    public Map<Object, MonitoredExecution> ongoingExecutions() {
        return this.ongoingExecutions;
    }

    public MonitoredExecution ongoingExecutionFor(AgenticScope agenticScope) {
        return this.ongoingExecutionFor(agenticScope.memoryId());
    }

    public MonitoredExecution ongoingExecutionFor(Object memoryId) {
        return this.ongoingExecutions.get(memoryId);
    }

    public List<MonitoredExecution> successfulExecutions() {
        return this.successfulExecutions.values().stream().flatMap(Collection::stream).toList();
    }

    public List<MonitoredExecution> successfulExecutionsFor(AgenticScope agenticScope) {
        return this.successfulExecutionsFor(agenticScope.memoryId());
    }

    public List<MonitoredExecution> successfulExecutionsFor(Object memoryId) {
        return this.successfulExecutions.getOrDefault(memoryId, List.of());
    }

    public List<MonitoredExecution> failedExecutions() {
        return this.failedExecutions.values().stream().flatMap(Collection::stream).toList();
    }

    public List<MonitoredExecution> failedExecutionsFor(AgenticScope agenticScope) {
        return this.failedExecutionsFor(agenticScope.memoryId());
    }

    public List<MonitoredExecution> failedExecutionsFor(Object memoryId) {
        return this.failedExecutions.getOrDefault(memoryId, List.of());
    }
}

