/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.MissingArgumentException;
import dev.langchain4j.agentic.internal.AgentInvocationArguments;
import dev.langchain4j.agentic.internal.AgentSpecsProvider;
import dev.langchain4j.agentic.internal.InternalAgent;
import dev.langchain4j.agentic.internal.MethodAgentInvoker;
import dev.langchain4j.agentic.internal.NonAiAgentInstance;
import dev.langchain4j.agentic.internal.UntypedAgentInvoker;
import dev.langchain4j.agentic.observability.AgentListener;
import dev.langchain4j.agentic.observability.AgentListenerProvider;
import dev.langchain4j.agentic.observability.ComposedAgentListener;
import dev.langchain4j.agentic.observability.ListenerNotifierUtil;
import dev.langchain4j.agentic.planner.AgentArgument;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.invocation.LangChain4jManaged;
import dev.langchain4j.service.ParameterNameResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface AgentInvoker
extends AgentInstance,
AgentListenerProvider,
InternalAgent {
    public Method method();

    public AgentInvocationArguments toInvocationArguments(AgenticScope var1) throws MissingArgumentException;

    default public Object invoke(DefaultAgenticScope agenticScope, Object agent, AgentInvocationArguments args) throws AgentInvocationException {
        AgentListener listener = ComposedAgentListener.composeWithInherited(this.listener(), agenticScope.listener());
        ListenerNotifierUtil.beforeAgentInvocation(listener, agenticScope, this, args.namedArgs());
        Object result = this.internalInvoke(agenticScope, listener, agent, args);
        ListenerNotifierUtil.afterAgentInvocation(listener, agenticScope, this, args.namedArgs(), result);
        return result;
    }

    private Object internalInvoke(DefaultAgenticScope agenticScope, AgentListener listener, Object agent, AgentInvocationArguments args) {
        LangChain4jManaged.setCurrent(Map.of(AgenticScope.class, agenticScope));
        AgentListener higherLevelListener = this.leaf() ? null : agenticScope.replaceListener(listener);
        try {
            Object object = this.method().invoke(agent, args.positionalArgs());
            return object;
        }
        catch (Exception e) {
            AgentInvocationException invocationException = new AgentInvocationException("Failed to invoke agent method: " + String.valueOf(this.method()), e);
            ListenerNotifierUtil.agentError(listener, agenticScope, this, args.namedArgs(), (Throwable)((Object)invocationException));
            throw invocationException;
        }
        finally {
            if (!this.leaf()) {
                agenticScope.setListener(higherLevelListener);
            }
            LangChain4jManaged.removeCurrent();
        }
    }

    public static AgentInvoker fromSpec(AgentSpecsProvider spec, Method agenticMethod, String name) {
        List<AgentArgument> arguments = List.of(new AgentArgument(agenticMethod.getGenericParameterTypes()[0], spec.inputKey()));
        NonAiAgentInstance agentInstance = new NonAiAgentInstance(agenticMethod.getDeclaringClass(), name, spec.description(), agenticMethod.getGenericReturnType(), spec.outputKey(), spec.async(), arguments, spec.listener());
        return new MethodAgentInvoker(agenticMethod, agentInstance);
    }

    public static AgentInvoker fromMethod(InternalAgent agent, Method method) {
        if (method.getDeclaringClass() == UntypedAgent.class) {
            return new UntypedAgentInvoker(method, agent);
        }
        return new MethodAgentInvoker(method, agent);
    }

    public static String parameterName(Parameter parameter) {
        return AgentInvoker.optionalParameterName(parameter).orElseThrow(() -> new IllegalArgumentException("Parameter name not specified and no @V or @K annotation present: " + String.valueOf(parameter)));
    }

    public static Optional<String> optionalParameterName(Parameter parameter) {
        return Optional.ofNullable(ParameterNameResolver.name((Parameter)parameter));
    }
}

