/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.internal.AgentInvocationArguments;
import dev.langchain4j.agentic.internal.AgentInvocationListener;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.internal.AsyncResponse;
import dev.langchain4j.agentic.internal.InternalAgent;
import dev.langchain4j.agentic.planner.AgentArgument;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.planner.AgenticSystemTopology;
import dev.langchain4j.agentic.scope.AgentInvocation;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record AgentExecutor(AgentInvoker agentInvoker, Object agent) implements AgentInstance,
InternalAgent
{
    private static final Logger LOG = LoggerFactory.getLogger(AgentExecutor.class);

    public Object execute(DefaultAgenticScope agenticScope, AgentInvocationListener listener) {
        return this.execute(agenticScope, listener, this.agentInvoker.async());
    }

    public Object syncExecute(DefaultAgenticScope agenticScope, AgentInvocationListener listener) {
        if (this.agentInvoker.async()) {
            LOG.info("Executing '{}' agent in a sync way even if declared as async", (Object)this.agentInvoker.name());
        }
        return this.execute(agenticScope, listener, false);
    }

    private Object execute(DefaultAgenticScope agenticScope, AgentInvocationListener listener, boolean async) {
        Object object;
        Object object2 = this.agent;
        if (object2 instanceof AgenticScopeOwner) {
            AgenticScopeOwner co = (AgenticScopeOwner)object2;
            object = co.withAgenticScope(agenticScope);
        } else {
            object = this.agent;
        }
        Object invokedAgent = object;
        return this.internalExecute(agenticScope, invokedAgent, listener, async);
    }

    private Object handleAgentFailure(AgentInvocationException e, DefaultAgenticScope agenticScope, Object invokedAgent, AgentInvocationListener listener) {
        ErrorRecoveryResult recoveryResult = agenticScope.handleError(this.agentInvoker.name(), e);
        return switch (recoveryResult.type()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorRecoveryResult.Type.THROW_EXCEPTION -> throw e;
            case ErrorRecoveryResult.Type.RETRY -> this.internalExecute(agenticScope, invokedAgent, listener, false);
            case ErrorRecoveryResult.Type.RETURN_RESULT -> recoveryResult.result();
        };
    }

    private Object internalExecute(DefaultAgenticScope agenticScope, Object invokedAgent, AgentInvocationListener listener, boolean async) {
        try {
            AgentInvocationArguments args = this.agentInvoker.toInvocationArguments(agenticScope);
            Object response = async ? new AsyncResponse<Object>(() -> {
                try {
                    return this.agentInvoker.invoke(agenticScope, invokedAgent, args);
                }
                catch (AgentInvocationException e) {
                    return this.handleAgentFailure(e, agenticScope, invokedAgent, listener);
                }
            }) : this.agentInvoker.invoke(agenticScope, invokedAgent, args);
            String outputKey = this.agentInvoker.outputKey();
            if (outputKey != null && !outputKey.isBlank()) {
                agenticScope.writeState(outputKey, response);
            }
            AgentInvocation agentInvocation = new AgentInvocation(this.type(), this.name(), this.agentId(), args.namedArgs(), response);
            agenticScope.registerAgentInvocation(agentInvocation, invokedAgent);
            if (listener != null) {
                listener.onAgentInvoked(agentInvocation);
            }
            return response;
        }
        catch (AgentInvocationException e) {
            return this.handleAgentFailure(e, agenticScope, invokedAgent, listener);
        }
    }

    @Override
    public Class<?> type() {
        return this.agentInvoker.type();
    }

    @Override
    public String name() {
        return this.agentInvoker.name();
    }

    @Override
    public String agentId() {
        return this.agentInvoker.agentId();
    }

    @Override
    public String description() {
        return this.agentInvoker.description();
    }

    @Override
    public Type outputType() {
        return this.agentInvoker.outputType();
    }

    @Override
    public String outputKey() {
        return this.agentInvoker.outputKey();
    }

    @Override
    public List<AgentArgument> arguments() {
        return this.agentInvoker.arguments();
    }

    @Override
    public List<AgentInstance> subagents() {
        return this.agentInvoker.subagents();
    }

    @Override
    public boolean async() {
        return this.agentInvoker.async();
    }

    @Override
    public AgenticSystemTopology topology() {
        return this.agentInvoker.topology();
    }

    @Override
    public AgentInstance parent() {
        return this.agentInvoker.parent();
    }

    @Override
    public void setParent(AgentInstance parent) {
        this.agentInvoker.setParent(parent);
    }

    @Override
    public void appendId(String idSuffix) {
        this.agentInvoker.appendId(idSuffix);
    }

    void setParent(AgentInstance parent, int index) {
        this.setParent(parent);
        this.propagateParentIndex(this.agentInvoker, index);
    }

    private void propagateParentIndex(InternalAgent agent, int index) {
        agent.appendId("$" + index);
        for (AgentInstance subagent : agent.subagents()) {
            if (!(subagent instanceof InternalAgent)) continue;
            InternalAgent internalAgent = (InternalAgent)subagent;
            this.propagateParentIndex(internalAgent, index);
        }
    }
}

