/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.supervisor;

import dev.langchain4j.agentic.internal.AbstractAgentInvocationHandler;
import dev.langchain4j.agentic.internal.AbstractService;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.internal.Context;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.AgenticScopeAccess;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.supervisor.AgentInvocation;
import dev.langchain4j.agentic.supervisor.PlannerAgent;
import dev.langchain4j.agentic.supervisor.ResponseAgent;
import dev.langchain4j.agentic.supervisor.ResponseScore;
import dev.langchain4j.agentic.supervisor.SupervisorAgent;
import dev.langchain4j.agentic.supervisor.SupervisorAgentService;
import dev.langchain4j.agentic.supervisor.SupervisorContextStrategy;
import dev.langchain4j.agentic.supervisor.SupervisorResponseStrategy;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorAgentServiceImpl<T>
extends AbstractService<T, SupervisorAgentServiceImpl<T>>
implements SupervisorAgentService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorAgentServiceImpl.class);
    public static final String SUPERVISOR_CONTEXT_KEY = "supervisorContext";
    public static final String SUPERVISOR_CONTEXT_PREFIX = "Use the following supervisor context to better understand constraints, policies or preferences when creating the plan ";
    private ChatModel chatModel;
    private ChatMemoryProvider chatMemoryProvider;
    private int maxAgentsInvocations = 10;
    private ResponseAgent responseAgent;
    private final Map<String, AgentExecutor> agents = new HashMap<String, AgentExecutor>();
    private String agentsList;
    private SupervisorContextStrategy contextStrategy = SupervisorContextStrategy.CHAT_MEMORY;
    private SupervisorResponseStrategy responseStrategy = SupervisorResponseStrategy.LAST;
    private Function<AgenticScope, String> requestGenerator;
    private String supervisorContext;

    private SupervisorAgentServiceImpl(Class<T> agentServiceClass, Method agenticMethod) {
        super(agentServiceClass, agenticMethod);
    }

    @Override
    public T build() {
        if (this.responseStrategy == SupervisorResponseStrategy.SCORED) {
            this.responseAgent = (ResponseAgent)AiServices.builder(ResponseAgent.class).chatModel(this.chatModel).build();
        }
        if (this.supervisorContext != null) {
            this.beforeCall(agenticScope -> {
                if (!agenticScope.hasState(SUPERVISOR_CONTEXT_KEY)) {
                    agenticScope.writeState(SUPERVISOR_CONTEXT_KEY, this.supervisorContext);
                }
            });
        }
        return this.build(null);
    }

    T build(DefaultAgenticScope agenticScope) {
        return (T)Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, AgentSpecification.class, AgenticScopeOwner.class, AgenticScopeAccess.class}, (InvocationHandler)new SupervisorInvocationHandler(this.buildPlannerAgent(agenticScope), agenticScope));
    }

    private PlannerAgent buildPlannerAgent(AgenticScope agenticScope) {
        if (agenticScope == null && this.isAgenticScopeDependent()) {
            return null;
        }
        AiServices builder = AiServices.builder(PlannerAgent.class).chatModel(this.chatModel);
        this.configureMemoryAndContext(agenticScope, (AiServices<PlannerAgent>)builder);
        return (PlannerAgent)builder.build();
    }

    private void configureMemoryAndContext(AgenticScope agenticScope, AiServices<PlannerAgent> builder) {
        if (this.chatMemoryProvider != null) {
            builder.chatMemoryProvider(this.chatMemoryProvider);
            if (this.contextStrategy != SupervisorContextStrategy.CHAT_MEMORY) {
                builder.chatRequestTransformer((BiFunction)new Context.Summarizer(agenticScope, this.chatModel, new String[0]));
            }
        } else {
            switch (this.contextStrategy) {
                case CHAT_MEMORY: {
                    builder.chatMemoryProvider(memoryId -> MessageWindowChatMemory.withMaxMessages((int)20));
                    break;
                }
                case SUMMARIZATION: {
                    builder.chatMemoryProvider(memoryId -> MessageWindowChatMemory.withMaxMessages((int)2)).chatRequestTransformer((BiFunction)new Context.Summarizer(agenticScope, this.chatModel, new String[0]));
                    break;
                }
                case CHAT_MEMORY_AND_SUMMARIZATION: {
                    builder.chatMemoryProvider(memoryId -> MessageWindowChatMemory.withMaxMessages((int)20)).chatRequestTransformer((BiFunction)new Context.Summarizer(agenticScope, this.chatModel, new String[0]));
                }
            }
        }
    }

    private boolean isAgenticScopeDependent() {
        return this.contextStrategy != SupervisorContextStrategy.CHAT_MEMORY;
    }

    public static SupervisorAgentService<SupervisorAgent> builder() {
        return new SupervisorAgentServiceImpl<SupervisorAgent>(SupervisorAgent.class, null);
    }

    public static <T> SupervisorAgentService<T> builder(Class<T> agentServiceClass) {
        return new SupervisorAgentServiceImpl<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass, false));
    }

    @Override
    public SupervisorAgentServiceImpl<T> chatModel(ChatModel chatModel) {
        this.chatModel = chatModel;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> chatMemoryProvider(ChatMemoryProvider chatMemoryProvider) {
        this.chatMemoryProvider = chatMemoryProvider;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> requestGenerator(Function<AgenticScope, String> requestGenerator) {
        this.requestGenerator = requestGenerator;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> contextGenerationStrategy(SupervisorContextStrategy contextStrategy) {
        this.contextStrategy = contextStrategy;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> responseStrategy(SupervisorResponseStrategy responseStrategy) {
        this.responseStrategy = responseStrategy;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> supervisorContext(String supervisorContext) {
        this.supervisorContext = supervisorContext;
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> subAgents(List<AgentExecutor> agentExecutors) {
        for (AgentExecutor agentExecutor : agentExecutors) {
            if (!agentExecutor.agentInvoker().description().isEmpty()) {
                this.agents.put(agentExecutor.agentInvoker().uniqueName(), agentExecutor);
                continue;
            }
            throw new IllegalArgumentException("Agent '" + agentExecutor.agentInvoker().name() + "' must have a non-empty description in order to be used by the supervisor agent.");
        }
        this.agentsList = this.agents.values().stream().map(AgentExecutor::agentInvoker).map(AgentInvoker::toCard).collect(Collectors.joining(", "));
        return this;
    }

    @Override
    public SupervisorAgentServiceImpl<T> maxAgentsInvocations(int maxAgentsInvocations) {
        this.maxAgentsInvocations = maxAgentsInvocations;
        return this;
    }

    private class SupervisorInvocationHandler
    extends AbstractAgentInvocationHandler {
        private final PlannerAgent plannerAgent;

        public SupervisorInvocationHandler(PlannerAgent plannerAgent, DefaultAgenticScope agenticScope) {
            super(SupervisorAgentServiceImpl.this, agenticScope);
            this.plannerAgent = plannerAgent;
        }

        @Override
        protected Object accessChatMemory(String methodName, Object memoryId) {
            return switch (methodName) {
                case "getChatMemory" -> this.plannerAgent.getChatMemory(memoryId);
                case "evictChatMemory" -> Boolean.valueOf(this.plannerAgent.evictChatMemory(memoryId));
                default -> throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + methodName);
            };
        }

        @Override
        protected Object doAgentAction(DefaultAgenticScope agenticScope) {
            String request = SupervisorAgentServiceImpl.this.requestGenerator != null ? SupervisorAgentServiceImpl.this.requestGenerator.apply(agenticScope) : agenticScope.readState("request", "");
            String lastResponse = "";
            AgentInvocation done = null;
            Object memoryId = agenticScope.memoryId();
            for (int loopCount = 0; loopCount < SupervisorAgentServiceImpl.this.maxAgentsInvocations; ++loopCount) {
                PlannerAgent planner = SupervisorAgentServiceImpl.this.isAgenticScopeDependent() ? agenticScope.getOrCreateAgent(this.agentId(), SupervisorAgentServiceImpl.this::buildPlannerAgent) : this.plannerAgent;
                String supervisorContext = agenticScope.hasState(SupervisorAgentServiceImpl.SUPERVISOR_CONTEXT_KEY) ? "Use the following supervisor context to better understand constraints, policies or preferences when creating the plan '" + agenticScope.readState(SupervisorAgentServiceImpl.SUPERVISOR_CONTEXT_KEY, "") + "'." : "";
                AgentInvocation agentInvocation = planner.plan(memoryId, SupervisorAgentServiceImpl.this.agentsList, request, lastResponse, supervisorContext);
                LOG.info("Agent Invocation: {}", (Object)agentInvocation);
                if (agentInvocation.getAgentName().equalsIgnoreCase("done")) {
                    done = agentInvocation;
                    break;
                }
                String agentName = agentInvocation.getAgentName();
                AgentExecutor agentExec = SupervisorAgentServiceImpl.this.agents.get(agentName);
                if (agentExec == null) {
                    throw new IllegalStateException("No agent found with name: " + agentName);
                }
                AgentInvoker agentSpec = agentExec.agentInvoker();
                if (agentSpec == null) {
                    throw new IllegalStateException("No specification found for agent: " + agentName);
                }
                agentInvocation.getArguments().forEach(agenticScope::writeState);
                lastResponse = agentExec.syncExecute(agenticScope).toString();
            }
            Object result = this.result(agenticScope, request, lastResponse, done);
            if (this.outputName != null) {
                agenticScope.writeState(this.outputName, result);
            }
            return result;
        }

        private Object result(DefaultAgenticScope agenticScope, String request, String lastResponse, AgentInvocation done) {
            String doneResponse;
            if (SupervisorAgentServiceImpl.this.hasOutputFunction()) {
                return SupervisorAgentServiceImpl.this.output.apply(agenticScope);
            }
            String string = doneResponse = done != null ? done.getArguments().get("response") : null;
            if (doneResponse == null) {
                return lastResponse;
            }
            return switch (SupervisorAgentServiceImpl.this.responseStrategy) {
                default -> throw new IncompatibleClassChangeError();
                case SupervisorResponseStrategy.LAST -> lastResponse;
                case SupervisorResponseStrategy.SUMMARY -> doneResponse;
                case SupervisorResponseStrategy.SCORED -> {
                    ResponseScore score = SupervisorAgentServiceImpl.this.responseAgent.scoreResponses(request, lastResponse, doneResponse);
                    LOG.info("Response scores: {}", (Object)score);
                    if (score.getScore2() > score.getScore1()) {
                        yield doneResponse;
                    }
                    yield lastResponse;
                }
            };
        }

        @Override
        protected InvocationHandler createSubAgentWithAgenticScope(DefaultAgenticScope agenticScope) {
            return new SupervisorInvocationHandler(this.plannerAgent, agenticScope);
        }

        private String agentId() {
            return this.outputName + "@Supervisor";
        }
    }
}

