/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.workflow.impl;

import dev.langchain4j.agentic.planner.Action;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.planner.InitPlanningContext;
import dev.langchain4j.agentic.planner.Planner;
import dev.langchain4j.agentic.planner.PlanningContext;
import dev.langchain4j.agentic.scope.AgenticScope;
import java.util.List;
import java.util.function.BiPredicate;

public class LoopPlanner
implements Planner {
    private final int maxIterations;
    private int iterationsCounter = 1;
    private final boolean testExitAtLoopEnd;
    private final BiPredicate<AgenticScope, Integer> exitCondition;
    private List<AgentInstance> agents;
    private int agentCursor = 0;

    public LoopPlanner(int maxIterations, boolean testExitAtLoopEnd, BiPredicate<AgenticScope, Integer> exitCondition) {
        this.maxIterations = maxIterations;
        this.testExitAtLoopEnd = testExitAtLoopEnd;
        this.exitCondition = exitCondition;
    }

    @Override
    public void init(InitPlanningContext initPlanningContext) {
        this.agents = initPlanningContext.subagents();
    }

    @Override
    public Action firstAction(PlanningContext planningContext) {
        return this.call(this.agents.get(this.agentCursor));
    }

    @Override
    public Action nextAction(PlanningContext planningContext) {
        this.agentCursor = (this.agentCursor + 1) % this.agents.size();
        if (this.agentCursor == 0) {
            if (this.iterationsCounter > this.maxIterations || this.exitCondition.test(planningContext.agenticScope(), this.iterationsCounter)) {
                return this.done();
            }
            ++this.iterationsCounter;
        } else if (!this.testExitAtLoopEnd && this.exitCondition.test(planningContext.agenticScope(), this.iterationsCounter)) {
            return this.done();
        }
        return this.call(this.agents.get(this.agentCursor));
    }
}

