/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.agent.ErrorContext;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.internal.AbstractServiceBuilder;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.planner.Action;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.planner.ChatMemoryAccessProvider;
import dev.langchain4j.agentic.planner.DefaultAgentInstance;
import dev.langchain4j.agentic.planner.InitPlanningContext;
import dev.langchain4j.agentic.planner.Planner;
import dev.langchain4j.agentic.planner.PlanningContext;
import dev.langchain4j.agentic.scope.AgentInvocation;
import dev.langchain4j.agentic.scope.AgentInvocationListener;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.AgenticScopeAccess;
import dev.langchain4j.agentic.scope.AgenticScopeRegistry;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.scope.ResultWithAgenticScope;
import dev.langchain4j.internal.DefaultExecutorProvider;
import dev.langchain4j.service.MemoryId;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class PlannerBasedInvocationHandler
implements InvocationHandler {
    private final Executor executor;
    private final AgentInstance plannerAgent;
    private final Function<AgenticScope, Object> output;
    private final Consumer<AgentRequest> beforeListener;
    private final Consumer<AgentResponse> afterListener;
    private final Consumer<AgenticScope> beforeCall;
    private final DefaultAgenticScope agenticScope;
    private final Function<ErrorContext, ErrorRecoveryResult> errorHandler;
    private final AtomicReference<AgenticScopeRegistry> agenticScopeRegistry = new AtomicReference();
    private final AbstractServiceBuilder<?, ?> service;
    private final Supplier<Planner> plannerSupplier;

    public PlannerBasedInvocationHandler(AbstractServiceBuilder<?, ?> service, Supplier<Planner> plannerSupplier) {
        this(service, plannerSupplier, null);
    }

    private PlannerBasedInvocationHandler(AbstractServiceBuilder<?, ?> service, Supplier<Planner> plannerSupplier, DefaultAgenticScope agenticScope) {
        this.service = service;
        this.output = service.output;
        this.executor = service.executor;
        this.beforeCall = service.beforeCall;
        this.errorHandler = service.errorHandler;
        this.beforeListener = service.beforeListener;
        this.afterListener = service.afterListener;
        this.plannerSupplier = plannerSupplier;
        this.agenticScope = agenticScope;
        this.plannerAgent = new DefaultAgentInstance(service.agentServiceClass, service.name, AgentUtil.uniqueAgentName(service.agentServiceClass, service.name), service.description, service.agentReturnType(), service.outputKey, service.agenticMethod != null ? AgentUtil.argumentsFromMethod(service.agenticMethod) : List.of(), service.agentExecutors().stream().map(AgentInstance.class::cast).toList());
        AgentUtil.agenticSystemDataTypes(this.plannerAgent);
    }

    public AgenticScopeOwner withAgenticScope(DefaultAgenticScope agenticScope) {
        return (AgenticScopeOwner)Proxy.newProxyInstance(this.plannerAgent.type().getClassLoader(), new Class[]{this.plannerAgent.type(), AgentSpecification.class, AgenticScopeOwner.class}, (InvocationHandler)new PlannerBasedInvocationHandler(this.service, this.plannerSupplier, agenticScope));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        AgenticScopeRegistry registry = this.agenticScopeRegistry();
        if (method.getDeclaringClass() == AgenticScopeOwner.class) {
            return switch (method.getName()) {
                case "withAgenticScope" -> this.withAgenticScope((DefaultAgenticScope)args[0]);
                case "registry" -> registry;
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeOwner class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgenticScopeAccess.class) {
            return switch (method.getName()) {
                case "getAgenticScope" -> registry.get(args[0]);
                case "evictAgenticScope" -> registry.evict(args[0]);
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeAccess class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgentInstance.class) {
            return switch (method.getName()) {
                case "type" -> this.plannerAgent.type();
                case "name" -> this.plannerAgent.name();
                case "agentId" -> this.plannerAgent.agentId();
                case "description" -> this.plannerAgent.description();
                case "outputType" -> this.plannerAgent.outputType();
                case "outputKey" -> this.plannerAgent.outputKey();
                case "arguments" -> this.plannerAgent.arguments();
                case "subagents" -> this.plannerAgent.subagents();
                default -> throw new UnsupportedOperationException("Unknown method on AgentInstance class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgentSpecification.class) {
            return switch (method.getName()) {
                case "async" -> false;
                case "beforeInvocation" -> {
                    this.beforeListener.accept((AgentRequest)args[0]);
                    yield null;
                }
                case "afterInvocation" -> {
                    this.afterListener.accept((AgentResponse)args[0]);
                    yield null;
                }
                default -> throw new UnsupportedOperationException("Unknown method on AgentSpecification class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == Object.class) {
            return switch (method.getName()) {
                case "toString" -> this.service.serviceType() + "<" + this.plannerAgent.type().getSimpleName() + ">";
                case "hashCode" -> System.identityHashCode(this);
                default -> throw new UnsupportedOperationException("Unknown method on Object class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == ChatMemoryAccess.class) {
            Object memoryId = args[0];
            return this.accessChatMemory(registry.getOrCreate(memoryId), method.getName(), memoryId);
        }
        return this.executeAgentMethod(registry, method, args);
    }

    private AgenticScopeRegistry agenticScopeRegistry() {
        if (this.isRootCall()) {
            this.agenticScopeRegistry.compareAndSet(null, new AgenticScopeRegistry(this.plannerAgent.type().getName()));
        }
        return this.agenticScopeRegistry.get();
    }

    private Object executeAgentMethod(AgenticScopeRegistry registry, Method method, Object[] args) {
        DefaultAgenticScope currentScope = this.currentAgenticScope(registry, method, args);
        PlannerBasedInvocationHandler.writeAgenticScope(currentScope, method, args);
        this.beforeCall.accept(currentScope);
        if (this.isRootCall()) {
            currentScope.rootCallStarted(registry);
        }
        Planner planner = this.plannerSupplier.get();
        planner.init(new InitPlanningContext(currentScope, this.plannerAgent, this.plannerAgent.subagents()));
        Object result = new PlannerLoop(planner, currentScope).loop();
        if (this.isRootCall()) {
            currentScope.rootCallEnded(registry);
        }
        Object output = this.plannerAgent.outputKey() != null ? currentScope.readState(this.plannerAgent.outputKey()) : result;
        return method.getReturnType().equals(ResultWithAgenticScope.class) ? new ResultWithAgenticScope<Object>(currentScope, output) : output;
    }

    private boolean isRootCall() {
        return this.agenticScope == null;
    }

    private static void writeAgenticScope(DefaultAgenticScope agenticScope, Method method, Object[] args) {
        if (method.getDeclaringClass() == UntypedAgent.class) {
            agenticScope.writeStates((Map)args[0]);
        } else {
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                int index = i;
                AgentInvoker.optionalParameterName(parameters[i]).ifPresent(argName -> agenticScope.writeState((String)argName, args[index]));
            }
        }
    }

    private DefaultAgenticScope currentAgenticScope(AgenticScopeRegistry registry, Method method, Object[] args) {
        if (this.agenticScope != null) {
            return this.agenticScope;
        }
        Object memoryId = this.memoryId(method, args);
        DefaultAgenticScope newAgenticScope = memoryId != null ? registry.getOrCreate(memoryId) : registry.createEphemeralAgenticScope();
        return newAgenticScope.withErrorHandler(this.errorHandler);
    }

    private Object memoryId(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(MemoryId.class) == null) continue;
            return args[i];
        }
        return null;
    }

    private Object accessChatMemory(AgenticScope agenticScope, String methodName, Object memoryId) {
        ChatMemoryAccess chatMemoryAccess = ((ChatMemoryAccessProvider)((Object)this.plannerSupplier.get())).chatMemoryAccess(agenticScope);
        return switch (methodName) {
            case "getChatMemory" -> chatMemoryAccess.getChatMemory(memoryId);
            case "evictChatMemory" -> Boolean.valueOf(chatMemoryAccess.evictChatMemory(memoryId));
            default -> throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + methodName);
        };
    }

    private class PlannerLoop
    implements AgentInvocationListener {
        private final Planner planner;
        private final DefaultAgenticScope agenticScope;
        private Action nextAction = null;

        private PlannerLoop(Planner planner, DefaultAgenticScope agenticScope) {
            this.planner = planner;
            this.agenticScope = agenticScope;
        }

        public Object loop() {
            this.nextAction = this.planner.firstAction(new PlanningContext(this.agenticScope, null));
            block4: while (this.nextAction == null || !this.nextAction.isDone()) {
                if (this.nextAction == null) {
                    Thread.yield();
                    continue;
                }
                List<AgentExecutor> agents = ((Action.AgentCallAction)this.nextAction).agentsToCall();
                this.nextAction = null;
                switch (agents.size()) {
                    case 0: {
                        Thread.yield();
                        continue block4;
                    }
                    case 1: {
                        agents.get(0).execute(this.agenticScope, this);
                        continue block4;
                    }
                }
                this.parallelExecution(agents);
            }
            return this.result();
        }

        private void parallelExecution(List<AgentExecutor> agents) {
            ExecutorService exec = PlannerBasedInvocationHandler.this.executor != null ? PlannerBasedInvocationHandler.this.executor : DefaultExecutorProvider.getDefaultExecutorService();
            List<CompletableFuture> tasks = agents.stream().map(agentExecutor -> CompletableFuture.supplyAsync(() -> agentExecutor.execute(this.agenticScope, this), exec)).toList();
            try {
                for (Future future : tasks) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private Object result() {
            Object result;
            Object object = result = PlannerBasedInvocationHandler.this.output != null ? PlannerBasedInvocationHandler.this.output.apply(this.agenticScope) : this.nextAction.result();
            if (PlannerBasedInvocationHandler.this.plannerAgent.outputKey() != null) {
                if (result != null) {
                    this.agenticScope.writeState(PlannerBasedInvocationHandler.this.plannerAgent.outputKey(), result);
                    return result;
                }
                return this.agenticScope.readState(PlannerBasedInvocationHandler.this.plannerAgent.outputKey());
            }
            return result;
        }

        @Override
        public void onAgentInvoked(AgentInvocation agentInvocation) {
            this.nextAction = PlannerLoop.composeActions(this.nextAction, this.planner.nextAction(new PlanningContext(this.agenticScope, agentInvocation)));
        }

        private static Action composeActions(Action first, Action second) {
            if (first == null || first.isDone()) {
                return second;
            }
            if (second == null || second.isDone()) {
                return first;
            }
            ArrayList<AgentExecutor> agentsToCall = new ArrayList<AgentExecutor>();
            agentsToCall.addAll(((Action.AgentCallAction)first).agentsToCall());
            agentsToCall.addAll(((Action.AgentCallAction)second).agentsToCall());
            return new Action.AgentCallAction(agentsToCall);
        }
    }
}

