/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.agent.MissingArgumentException;
import dev.langchain4j.agentic.internal.AgentInvocationArguments;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentSpecsProvider;
import dev.langchain4j.agentic.internal.MethodAgentInvoker;
import dev.langchain4j.agentic.internal.NonAiAgentSpecification;
import dev.langchain4j.agentic.internal.UntypedAgentInvoker;
import dev.langchain4j.agentic.planner.AgentArgument;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.invocation.LangChain4jManaged;
import dev.langchain4j.service.ParameterNameResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AgentInvoker
extends AgentSpecification {
    public static final Logger LOG = LoggerFactory.getLogger(AgentInvoker.class);

    public Method method();

    public AgentInvocationArguments toInvocationArguments(AgenticScope var1) throws MissingArgumentException;

    default public Object invoke(AgenticScope agenticScope, Object agent, AgentInvocationArguments args) throws AgentInvocationException {
        try {
            this.beforeInvocation(new AgentRequest(agenticScope, this, args.namedArgs()));
        }
        catch (Exception e) {
            LOG.error("Before agent invocation listener for agent " + this.agentId() + " failed: " + e.getMessage(), (Throwable)e);
        }
        LangChain4jManaged.setCurrent(Map.of(AgenticScope.class, agenticScope));
        Object result = this.internalInvoke(agent, args);
        try {
            LangChain4jManaged.removeCurrent();
            this.afterInvocation(new AgentResponse(agenticScope, this, args.namedArgs(), result));
        }
        catch (Exception e) {
            LOG.error("After agent invocation listener for agent " + this.name() + " failed: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Object internalInvoke(Object agent, AgentInvocationArguments args) {
        try {
            return this.method().invoke(agent, args.positionalArgs());
        }
        catch (Exception e) {
            throw new AgentInvocationException("Failed to invoke agent method: " + String.valueOf(this.method()), e);
        }
    }

    public static AgentInvoker fromSpec(AgentSpecsProvider spec, Method agenticMethod, String name, String agentId) {
        List<AgentArgument> arguments = List.of(new AgentArgument(agenticMethod.getGenericParameterTypes()[0], spec.inputKey()));
        NonAiAgentSpecification agentSpecification = new NonAiAgentSpecification(agenticMethod.getDeclaringClass(), name, agentId, spec.description(), agenticMethod.getGenericReturnType(), spec.outputKey(), spec.async(), arguments, x -> {}, x -> {});
        return new MethodAgentInvoker(agenticMethod, agentSpecification);
    }

    public static AgentInvoker fromMethod(AgentSpecification spec, Method method) {
        if (method.getDeclaringClass() == UntypedAgent.class) {
            return new UntypedAgentInvoker(method, spec);
        }
        return new MethodAgentInvoker(method, spec);
    }

    public static String parameterName(Parameter parameter) {
        return AgentInvoker.optionalParameterName(parameter).orElseThrow(() -> new IllegalArgumentException("Parameter name not specified and no @V or @K annotation present: " + String.valueOf(parameter)));
    }

    public static Optional<String> optionalParameterName(Parameter parameter) {
        return Optional.ofNullable(ParameterNameResolver.name((Parameter)parameter));
    }
}

