/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.declarative;

import dev.langchain4j.Internal;
import dev.langchain4j.agentic.AgenticServices;
import dev.langchain4j.agentic.agent.AgentBuilder;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.declarative.AfterAgentInvocation;
import dev.langchain4j.agentic.declarative.BeforeAgentInvocation;
import dev.langchain4j.agentic.declarative.ChatMemoryProviderSupplier;
import dev.langchain4j.agentic.declarative.ChatMemorySupplier;
import dev.langchain4j.agentic.declarative.ChatModelSupplier;
import dev.langchain4j.agentic.declarative.ContentRetrieverSupplier;
import dev.langchain4j.agentic.declarative.RetrievalAugmentorSupplier;
import dev.langchain4j.agentic.declarative.ToolProviderSupplier;
import dev.langchain4j.agentic.declarative.ToolsSupplier;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.service.tool.ToolProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;

@Internal
public class DeclarativeUtil {
    private DeclarativeUtil() {
    }

    public static void configureAgent(Class<?> agentType, AgentBuilder<?> agentBuilder) {
        DeclarativeUtil.configureAgent(agentType, null, true, agentBuilder, ctx -> {});
    }

    public static void configureAgent(Class<?> agentType, ChatModel chatModel, AgentBuilder<?> agentBuilder, Consumer<AgenticServices.DeclarativeAgentCreationContext> agentConfigurator) {
        DeclarativeUtil.configureAgent(agentType, chatModel, false, agentBuilder, agentConfigurator);
    }

    private static void configureAgent(Class<?> agentType, ChatModel chatModel, boolean allowNullChatModel, AgentBuilder<?> agentBuilder, Consumer<AgenticServices.DeclarativeAgentCreationContext> agentConfigurator) {
        AgentUtil.getAnnotatedMethodOnClass(agentType, ToolsSupplier.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, new Class[0]);
            Object tools = DeclarativeUtil.invokeStatic(method, new Object[0]);
            if (tools instanceof Map) {
                agentBuilder.tools((Map)tools);
            } else if (tools.getClass().isArray()) {
                agentBuilder.tools((Object[])tools);
            } else {
                agentBuilder.tools(tools);
            }
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, ToolProviderSupplier.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, new Class[0]);
            DeclarativeUtil.checkReturnType(method, ToolProvider.class);
            agentBuilder.toolProvider((ToolProvider)DeclarativeUtil.invokeStatic(method, new Object[0]));
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, ContentRetrieverSupplier.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, new Class[0]);
            DeclarativeUtil.checkReturnType(method, ContentRetriever.class);
            agentBuilder.contentRetriever((ContentRetriever)DeclarativeUtil.invokeStatic(method, new Object[0]));
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, RetrievalAugmentorSupplier.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, new Class[0]);
            DeclarativeUtil.checkReturnType(method, RetrievalAugmentor.class);
            agentBuilder.retrievalAugmentor((RetrievalAugmentor)DeclarativeUtil.invokeStatic(method, new Object[0]));
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, ChatMemoryProviderSupplier.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, Object.class);
            DeclarativeUtil.checkReturnType(method, ChatMemory.class);
            agentBuilder.chatMemoryProvider(memoryId -> (ChatMemory)DeclarativeUtil.invokeStatic(method, memoryId));
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, ChatMemorySupplier.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, new Class[0]);
            DeclarativeUtil.checkReturnType(method, ChatMemory.class);
            agentBuilder.chatMemory((ChatMemory)DeclarativeUtil.invokeStatic(method, new Object[0]));
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, ChatModelSupplier.class).ifPresentOrElse(method -> {
            DeclarativeUtil.checkArguments(method, new Class[0]);
            DeclarativeUtil.checkReturnType(method, ChatModel.class);
            agentBuilder.chatModel((ChatModel)DeclarativeUtil.invokeStatic(method, new Object[0]));
        }, () -> {
            if (chatModel == null && !allowNullChatModel) {
                throw new IllegalArgumentException("ChatModel not provided for subagent " + agentType.getName() + ". Please provide a ChatModel either through the @ChatModelSupplier annotation on a static method or through the parent agent's chatModel parameter.");
            }
            agentBuilder.chatModel(chatModel);
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, BeforeAgentInvocation.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, AgentRequest.class);
            DeclarativeUtil.checkReturnType(method, Void.TYPE);
            agentBuilder.beforeAgentInvocation(request -> DeclarativeUtil.invokeStatic(method, request));
        });
        AgentUtil.getAnnotatedMethodOnClass(agentType, AfterAgentInvocation.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, AgentResponse.class);
            DeclarativeUtil.checkReturnType(method, Void.TYPE);
            agentBuilder.afterAgentInvocation(response -> DeclarativeUtil.invokeStatic(method, response));
        });
        agentConfigurator.accept(new AgenticServices.DefaultDeclarativeAgentCreationContext(agentType, agentBuilder));
    }

    public static void checkArguments(Method method, Class<?> ... expected) {
        Class<?>[] actual = method.getParameterTypes();
        if (actual.length != expected.length) {
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " must have " + expected.length + " arguments: " + Arrays.toString(expected));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i].isAssignableFrom(actual[i])) continue;
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " argument " + (i + 1) + " must be of type " + expected[i].getName());
        }
    }

    public static void checkReturnType(Method method, Class<?> expected) {
        if (!method.getReturnType().isAssignableFrom(expected)) {
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " must return " + expected.getName());
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) {
        try {
            return (T)method.invoke(null, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

