/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.a2a;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.a2a.A2AClientSpecification;
import dev.langchain4j.agentic.internal.A2AClientBuilder;
import dev.langchain4j.agentic.internal.AgentSpecification;
import io.a2a.A2A;
import io.a2a.client.A2AClient;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AServerException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.SendMessageResponse;
import io.a2a.spec.Task;
import io.a2a.spec.TextPart;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultA2AClientBuilder<T>
implements A2AClientBuilder<T> {
    private final Class<T> agentServiceClass;
    private final AgentCard agentCard;
    private final A2AClient a2aClient;
    private String[] inputNames;
    private String outputName;

    DefaultA2AClientBuilder(String a2aServerUrl, Class<T> agentServiceClass) {
        this.agentCard = DefaultA2AClientBuilder.agentCard(a2aServerUrl);
        this.a2aClient = new A2AClient(this.agentCard);
        this.agentServiceClass = agentServiceClass;
    }

    private static AgentCard agentCard(String a2aServerUrl) {
        try {
            return A2A.getAgentCard((String)a2aServerUrl);
        }
        catch (A2AClientError e) {
            throw new RuntimeException(e);
        }
    }

    public T build() {
        if (this.agentServiceClass == UntypedAgent.class && this.inputNames == null) {
            throw new IllegalArgumentException("Input names must be provided for UntypedAgent.");
        }
        Object agent = Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, A2AClientSpecification.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                if (method.getDeclaringClass() == AgentSpecification.class) {
                    return switch (method.getName()) {
                        case "name" -> DefaultA2AClientBuilder.this.agentCard.name();
                        case "description" -> DefaultA2AClientBuilder.this.agentCard.description();
                        case "outputName" -> DefaultA2AClientBuilder.this.outputName;
                        default -> throw new UnsupportedOperationException("Unknown method on AgentInstance class : " + method.getName());
                    };
                }
                if (method.getDeclaringClass() == A2AClientSpecification.class) {
                    return switch (method.getName()) {
                        case "agentCard" -> DefaultA2AClientBuilder.this.agentCard;
                        case "inputNames" -> DefaultA2AClientBuilder.this.inputNames;
                        default -> throw new UnsupportedOperationException("Unknown method on A2AClientInstance class : " + method.getName());
                    };
                }
                return DefaultA2AClientBuilder.this.invokeAgent(args);
            }
        });
        return (T)agent;
    }

    private Object invokeAgent(Object[] args) throws A2AServerException {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        if (this.agentServiceClass == UntypedAgent.class) {
            Map params = (Map)args[0];
            for (String inputName : this.inputNames) {
                parts.add(new TextPart(params.get(inputName).toString()));
            }
        } else {
            for (Object arg : args) {
                parts.add(new TextPart(arg.toString()));
            }
        }
        Message message = new Message.Builder().role(Message.Role.USER).parts(parts).build();
        MessageSendParams params = new MessageSendParams.Builder().message(message).build();
        SendMessageResponse response = this.a2aClient.sendMessage(params);
        return ((Task)response.getResult()).getArtifacts().stream().flatMap(a -> a.parts().stream()).filter(TextPart.class::isInstance).map(TextPart.class::cast).map(TextPart::getText).collect(Collectors.joining("\n"));
    }

    public DefaultA2AClientBuilder<T> inputNames(String ... inputNames) {
        this.inputNames = inputNames;
        return this;
    }

    public DefaultA2AClientBuilder<T> outputName(String outputName) {
        this.outputName = outputName;
        return this;
    }
}

