/*
 * Decompiled with CFR 0.152.
 */
package dev.iurysouza.modulegraph.gradle;

import dev.iurysouza.modulegraph.Dependency;
import dev.iurysouza.modulegraph.LinkText;
import dev.iurysouza.modulegraph.MermaidGraphKt;
import dev.iurysouza.modulegraph.Orientation;
import dev.iurysouza.modulegraph.Theme;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020!H\u0007R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\r\u00a8\u0006\""}, d2={"Ldev/iurysouza/modulegraph/gradle/CreateModuleGraphTask;", "Lorg/gradle/api/DefaultTask;", "()V", "dependencies", "Lorg/gradle/api/provider/MapProperty;", "", "", "Ldev/iurysouza/modulegraph/Dependency;", "getDependencies$modulegraph", "()Lorg/gradle/api/provider/MapProperty;", "heading", "Lorg/gradle/api/provider/Property;", "getHeading", "()Lorg/gradle/api/provider/Property;", "linkText", "Ldev/iurysouza/modulegraph/LinkText;", "getLinkText", "orientation", "Ldev/iurysouza/modulegraph/Orientation;", "getOrientation", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "readmePath", "getReadmePath", "showFullPath", "", "getShowFullPath", "theme", "Ldev/iurysouza/modulegraph/Theme;", "getTheme", "execute", "", "modulegraph"})
public abstract class CreateModuleGraphTask
extends DefaultTask {
    public CreateModuleGraphTask() {
        this.setGroup("Reporting");
        this.setDescription("Creates a mermaid dependency graph for the project");
    }

    @Input
    @Option(option="readmePath", description="The readme file path")
    @NotNull
    public abstract Property<String> getReadmePath();

    @Input
    @Option(option="theme", description="The mermaid theme")
    @Optional
    @NotNull
    public abstract Property<Theme> getTheme();

    @Input
    @Option(option="orientation", description="The flowchart orientation")
    @Optional
    @NotNull
    public abstract Property<Orientation> getOrientation();

    @Input
    @Option(option="showFullPath", description="Whether to show the modules full path")
    @Optional
    @NotNull
    public abstract Property<Boolean> getShowFullPath();

    @Input
    @Option(option="heading", description="The heading where the graph will be appended")
    @NotNull
    public abstract Property<String> getHeading();

    @Input
    @Option(option="linkText", description="Whether to add information as text on links in graph")
    @Optional
    @NotNull
    public abstract Property<LinkText> getLinkText();

    @Input
    @Option(option="dependencies", description="The project dependencies")
    @NotNull
    public abstract MapProperty<String, List<Dependency>> getDependencies$modulegraph();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public final void execute() {
        try {
            Object object = this.getTheme().getOrElse((Object)Theme.NEUTRAL.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"theme.getOrElse(Theme.NEUTRAL)");
            Theme theme = (Theme)object;
            Object object2 = this.getOrientation().getOrElse((Object)Orientation.LEFT_TO_RIGHT);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"orientation.getOrElse(Orientation.LEFT_TO_RIGHT)");
            Orientation orientation = (Orientation)((Object)object2);
            Object object3 = this.getLinkText().getOrElse((Object)LinkText.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"linkText.getOrElse(LinkText.NONE)");
            LinkText linkText = (LinkText)((Object)object3);
            Object object4 = this.getDependencies$modulegraph().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"dependencies.get()");
            Map map = (Map)object4;
            Object object5 = this.getShowFullPath().getOrElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"showFullPath.getOrElse(false)");
            String mermaidGraph = MermaidGraphKt.buildMermaidGraph(theme, orientation, linkText, map, (Boolean)object5);
            Object object6 = this.getHeading().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"heading.get()");
            String string = (String)object6;
            File file = ((RegularFile)this.getOutputFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.get().asFile");
            Logger logger = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            MermaidGraphKt.appendMermaidGraphToReadme(mermaidGraph, string, file, logger);
        }
        catch (Exception e) {
            this.getLogger().log(LogLevel.ERROR, e.getMessage(), (Throwable)e);
        }
    }
}

