/*
 * Decompiled with CFR 0.152.
 */
package dev.iurysouza.modulegraph;

import dev.iurysouza.modulegraph.Dependency;
import dev.iurysouza.modulegraph.LinkText;
import dev.iurysouza.modulegraph.MermaidGraphKt;
import dev.iurysouza.modulegraph.Orientation;
import dev.iurysouza.modulegraph.Theme;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a2\u0010\t\u001a\u00020\u00032\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001aB\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a2\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\fH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\"\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\f\u001a\u001e\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\"\u001a\u00020 H\u0002\u001a\u001e\u0010#\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010$\u001a\u00020\u0003H\u0002\u001a\u0014\u0010%\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010&\u001a\u00020\u0003*\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006("}, d2={"appendMermaidGraphToReadme", "", "mermaidGraph", "", "readMeSection", "readmeFile", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "buildDigraph", "dependencies", "", "", "Ldev/iurysouza/modulegraph/Dependency;", "showFullPath", "", "linkText", "Ldev/iurysouza/modulegraph/LinkText;", "buildMermaidGraph", "theme", "Ldev/iurysouza/modulegraph/Theme;", "orientation", "Ldev/iurysouza/modulegraph/Orientation;", "", "buildSubgraph", "mostMeaningfulGroups", "projectNames", "createConfig", "createSubgraph", "group", "modules", "findNextSectionStart", "", "readmeLines", "startIndex", "findPredefinedSection", "section", "getProjectName", "toLinkString", "configName", "modulegraph"})
@SourceDebugExtension(value={"SMAP\nMermaidGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MermaidGraph.kt\ndev/iurysouza/modulegraph/MermaidGraphKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,152:1\n451#2,6:153\n1603#2,9:169\n1855#2:178\n1856#2:180\n1612#2:181\n350#2,7:186\n350#2,7:193\n467#3,7:159\n76#4:166\n96#4,2:167\n98#4,3:182\n1#5:179\n113#6:185\n*S KotlinDebug\n*F\n+ 1 MermaidGraph.kt\ndev/iurysouza/modulegraph/MermaidGraphKt\n*L\n68#1:153,6\n78#1:169,9\n78#1:178\n78#1:180\n78#1:181\n144#1:186,7\n148#1:193,7\n76#1:159,7\n76#1:166\n76#1:167,2\n76#1:182,3\n78#1:179\n93#1:185\n*E\n"})
public final class MermaidGraphKt {
    @NotNull
    public static final String buildMermaidGraph(@NotNull Theme theme, @NotNull Orientation orientation, @NotNull LinkText linkText, @NotNull Map<String, List<Dependency>> dependencies, boolean showFullPath) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)((Object)linkText), (String)"linkText");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Sequence projectPaths2 = SequencesKt.sorted((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)dependencies.entrySet()), (Function1)buildMermaidGraph.projectPaths.1.INSTANCE));
        List mostMeaningfulGroups2 = SequencesKt.toList((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)projectPaths2, (Function1)buildMermaidGraph.mostMeaningfulGroups.1.INSTANCE))));
        List projectNames2 = SequencesKt.toList((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)projectPaths2, (Function1)buildMermaidGraph.projectNames.1.INSTANCE))));
        String subgraphs = MermaidGraphKt.buildSubgraph(showFullPath, mostMeaningfulGroups2, projectNames2);
        String digraph = MermaidGraphKt.buildDigraph(dependencies, showFullPath, linkText);
        return MermaidGraphKt.createConfig(theme) + "\n\ngraph " + orientation.getValue() + '\n' + subgraphs + digraph;
    }

    private static final String buildSubgraph(boolean showFullPath, List<String> mostMeaningfulGroups2, List<? extends List<String>> projectNames2) {
        return showFullPath ? "" : CollectionsKt.joinToString$default((Iterable)mostMeaningfulGroups2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(projectNames2){
            final /* synthetic */ List<List<String>> $projectNames;
            {
                this.$projectNames = $projectNames;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                return MermaidGraphKt.createSubgraph(group, this.$projectNames);
            }
        }), (int)30, null) + '\n';
    }

    private static final String toLinkString(LinkText $this$toLinkString, String configName) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toLinkString.ordinal()]) {
            case 1: {
                string = "-- " + configName + " -->";
                break;
            }
            case 2: {
                string = "-->";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String getProjectName(String $this$getProjectName, boolean showFullPath) {
        String string;
        if (showFullPath) {
            string = $this$getProjectName;
        } else {
            Object element$iv;
            block3: {
                String[] stringArray = new String[]{":"};
                List $this$last$iv = StringsKt.split$default((CharSequence)$this$getProjectName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$last = false;
                ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv = iterator$iv.previous();
                    String it = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    break block3;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            string = (String)element$iv;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String buildDigraph(Map<String, ? extends List<Dependency>> dependencies, boolean showFullPath, LinkText linkText) {
        void $this$flatMapTo$iv$iv;
        Map<String, ? extends List<Dependency>> $this$filterKeys$iv = dependencies;
        boolean $i$f$filterKeys = false;
        Map<String, List<Dependency>> result$iv = new LinkedHashMap();
        for (Map.Entry<String, ? extends List<Dependency>> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)":"))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$flatMap$iv = result$iv;
        boolean $i$f$flatMap = false;
        result$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String sourceName = MermaidGraphKt.getProjectName((String)entry.getKey(), showFullPath);
            Iterable $this$mapNotNull$iv = (Iterable)entry.getValue();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Dependency target = (Dependency)element$iv$iv2;
                boolean bl3 = false;
                String targetName = MermaidGraphKt.getProjectName(target.getTargetProjectPath(), showFullPath);
                if ((!Intrinsics.areEqual((Object)sourceName, (Object)targetName) ? "  " + sourceName + ' ' + MermaidGraphKt.toLinkString(linkText, target.getConfigName()) + ' ' + targetName : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String createConfig(Theme theme) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("\n%%{\n  init: {\n    'theme': '").append(theme.getName()).append('\'');
        if (theme instanceof Theme.BASE) {
            void $this$encodeToString$iv;
            StringBuilder stringBuilder2 = new StringBuilder().append(",\n\t'themeVariables': ");
            StringFormat stringFormat = (StringFormat)Json.Default;
            Map<String, String> value$iv = ((Theme.BASE)theme).getThemeVariables();
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            string = stringBuilder2.append(StringsKt.trimIndent((String)$this$encodeToString$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), value$iv))).toString();
        } else {
            string = "";
        }
        return StringsKt.trimIndent((String)stringBuilder.append(string).append("\n  }\n}%%\n").toString());
    }

    @NotNull
    public static final String createSubgraph(@NotNull String group, @NotNull List<? extends List<String>> modules) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        String moduleNames2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)modules), (Function1)createSubgraph.moduleNames.1.INSTANCE), (Function1)createSubgraph.moduleNames.2.INSTANCE), (Function1)((Function1)new Function1<List<? extends String>, Boolean>(group){
            final /* synthetic */ String $group;
            {
                this.$group = $group;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.contains(this.$group);
            }
        })), (Function1)createSubgraph.moduleNames.4.INSTANCE), (CharSequence)"\n    ", null, null, (int)0, null, (Function1)createSubgraph.moduleNames.5.INSTANCE, (int)30, null);
        if (StringsKt.isBlank((CharSequence)moduleNames2)) {
            return "";
        }
        return "  subgraph " + group + "\n    " + moduleNames2 + "\n  end";
    }

    public static final void appendMermaidGraphToReadme(@NotNull String mermaidGraph, @NotNull String readMeSection, @NotNull File readmeFile, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)mermaidGraph, (String)"mermaidGraph");
        Intrinsics.checkNotNullParameter((Object)readMeSection, (String)"readMeSection");
        Intrinsics.checkNotNullParameter((Object)readmeFile, (String)"readmeFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!readmeFile.exists()) {
            readmeFile.createNewFile();
            logger.warn(StringsKt.trimMargin$default((String)("\n                The specified README file was not found.\n                A new file has been created at: " + readmeFile.getPath() + "\n            "), null, (int)1, null));
        }
        List readmeLines = CollectionsKt.toMutableList((Collection)FilesKt.readLines$default((File)readmeFile, null, (int)1, null));
        int sectionStartIndex = MermaidGraphKt.findPredefinedSection(readmeLines, readMeSection);
        int sectionEndIndex = MermaidGraphKt.findNextSectionStart(readmeLines, sectionStartIndex);
        readmeLines.subList(sectionStartIndex + 1, sectionEndIndex).clear();
        if (sectionStartIndex == -1) {
            readmeLines.add(0, readMeSection + "\n\n```mermaid\n" + mermaidGraph + "\n```");
        } else {
            readmeLines.add(sectionStartIndex + 1, "\n```mermaid\n" + mermaidGraph + "\n```");
        }
        FilesKt.writeText$default((File)readmeFile, (String)CollectionsKt.joinToString$default((Iterable)readmeLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
        logger.debug("Module graph added to " + readmeFile.getPath() + " under the " + readMeSection + " section");
    }

    private static final int findPredefinedSection(List<String> readmeLines, String section) {
        int n;
        block2: {
            List<String> $this$indexOfFirst$iv = readmeLines;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                String item$iv;
                String it = item$iv = iterator.next();
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)section, (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final int findNextSectionStart(List<String> readmeLines, int startIndex) {
        int n;
        block2: {
            List $this$indexOfFirst$iv = CollectionsKt.drop((Iterable)readmeLines, (int)(startIndex + 1));
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        return it != -1 ? it + startIndex + 1 : readmeLines.size();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LinkText.values().length];
            try {
                nArray[LinkText.CONFIGURATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinkText.NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

