/*
 * Decompiled with CFR 0.152.
 */
package dev.iurysouza.modulegraph.gradle;

import dev.iurysouza.modulegraph.LinkText;
import dev.iurysouza.modulegraph.Orientation;
import dev.iurysouza.modulegraph.Theme;
import dev.iurysouza.modulegraph.gradle.CreateModuleGraphTask;
import dev.iurysouza.modulegraph.gradle.Module;
import dev.iurysouza.modulegraph.gradle.ModuleGraphExtension;
import dev.iurysouza.modulegraph.gradle.graphparser.ProjectParser;
import dev.iurysouza.modulegraph.gradle.graphparser.projectquerier.GradleProjectQuerier;
import dev.iurysouza.modulegraph.model.GraphConfig;
import dev.iurysouza.modulegraph.model.GraphParseResult;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Ldev/iurysouza/modulegraph/gradle/ModuleGraphPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "getPrimaryGraphConfig", "Ldev/iurysouza/modulegraph/model/GraphConfig;", "task", "Ldev/iurysouza/modulegraph/gradle/CreateModuleGraphTask;", "modulegraph"})
@SourceDebugExtension(value={"SMAP\nModuleGraphPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleGraphPlugin.kt\ndev/iurysouza/modulegraph/gradle/ModuleGraphPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1747#2,3:139\n1549#2:142\n1620#2,3:143\n1549#2:146\n1620#2,3:147\n*S KotlinDebug\n*F\n+ 1 ModuleGraphPlugin.kt\ndev/iurysouza/modulegraph/gradle/ModuleGraphPlugin\n*L\n115#1:139,3\n60#1:142\n60#1:143,3\n63#1:146\n63#1:147,3\n*E\n"})
public class ModuleGraphPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[]{project};
        ModuleGraphExtension extension = (ModuleGraphExtension)project.getExtensions().create("moduleGraphConfig", ModuleGraphExtension.class, objectArray);
        project.getTasks().register("createModuleGraph", CreateModuleGraphTask.class, arg_0 -> ModuleGraphPlugin.apply$lambda$3(arg_0 -> ModuleGraphPlugin.apply$lambda$2(extension, project, this, arg_0), arg_0));
    }

    private final GraphConfig getPrimaryGraphConfig(CreateModuleGraphTask task) {
        GraphConfig.Builder builder;
        boolean hasPrimaryConfig;
        Boolean nestingEnabled;
        Boolean strictMode;
        Boolean showFullPath;
        String rootModulesRegex;
        String excludedModulesRegex;
        String excludedConfigurationsRegex;
        Boolean setStyleByModuleType;
        LinkText linkText;
        String focusedModulesRegex;
        Orientation orientation;
        Theme theme;
        String heading;
        String readmePath;
        block6: {
            boolean bl;
            String string;
            String string2 = (String)task.getReadmePath().getOrNull();
            if (string2 == null) {
                File file = task.getProject().getRootDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getRootDir(...)");
                string2 = readmePath = FilesKt.resolve((File)file, (String)"README.md").getAbsolutePath();
            }
            if ((string = (String)task.getHeading().getOrNull()) == null) {
                string = "# Module Graph";
            }
            heading = string;
            theme = (Theme)task.getTheme().getOrNull();
            orientation = (Orientation)((Object)task.getOrientation().getOrNull());
            focusedModulesRegex = (String)task.getFocusedModulesRegex().getOrNull();
            linkText = (LinkText)((Object)task.getLinkText().getOrNull());
            setStyleByModuleType = (Boolean)task.getSetStyleByModuleType().getOrNull();
            excludedConfigurationsRegex = (String)task.getExcludedConfigurationsRegex().getOrNull();
            excludedModulesRegex = (String)task.getExcludedModulesRegex().getOrNull();
            rootModulesRegex = (String)task.getRootModulesRegex().getOrNull();
            showFullPath = (Boolean)task.getShowFullPath().getOrNull();
            strictMode = (Boolean)task.getStrictMode().getOrNull();
            nestingEnabled = (Boolean)task.getNestingEnabled().getOrNull();
            Object[] objectArray = new Serializable[]{readmePath, heading, theme, orientation, focusedModulesRegex, linkText, setStyleByModuleType, excludedConfigurationsRegex, excludedModulesRegex, rootModulesRegex, showFullPath, strictMode, nestingEnabled};
            List params = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = params;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(it != null)) continue;
                    bl = true;
                    break block6;
                }
                bl = hasPrimaryConfig = false;
            }
        }
        if (!hasPrimaryConfig) {
            return null;
        }
        Intrinsics.checkNotNull((Object)readmePath);
        GraphConfig.Builder $this$getPrimaryGraphConfig_u24lambda_u245 = builder = new GraphConfig.Builder(readmePath, heading);
        boolean bl = false;
        $this$getPrimaryGraphConfig_u24lambda_u245.setTheme(theme);
        $this$getPrimaryGraphConfig_u24lambda_u245.setOrientation(orientation);
        $this$getPrimaryGraphConfig_u24lambda_u245.setLinkText(linkText);
        $this$getPrimaryGraphConfig_u24lambda_u245.setSetStyleByModuleType(setStyleByModuleType);
        $this$getPrimaryGraphConfig_u24lambda_u245.setShowFullPath(showFullPath);
        $this$getPrimaryGraphConfig_u24lambda_u245.setExcludedConfigurationsRegex(excludedConfigurationsRegex);
        $this$getPrimaryGraphConfig_u24lambda_u245.setExcludedModulesRegex(excludedModulesRegex);
        $this$getPrimaryGraphConfig_u24lambda_u245.setRootModulesRegex(rootModulesRegex);
        $this$getPrimaryGraphConfig_u24lambda_u245.setFocusedModulesRegex(focusedModulesRegex);
        $this$getPrimaryGraphConfig_u24lambda_u245.setStrictMode(strictMode);
        $this$getPrimaryGraphConfig_u24lambda_u245.setNestingEnabled(nestingEnabled);
        return builder.build$modulegraph();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit apply$lambda$2(ModuleGraphExtension $extension, Project $project, ModuleGraphPlugin this$0, CreateModuleGraphTask task) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (Os.isFamily((String)"windows")) {
            task.doNotTrackState("https://github.com/iurysza/module-graph/issues/51");
        }
        task.getHeading().set((Provider)$extension.getHeading());
        task.getReadmePath().set((Provider)$extension.getReadmePath());
        task.getTheme().set((Provider)$extension.getTheme());
        task.getFocusedModulesRegex().set((Provider)$extension.getFocusedModulesRegex());
        task.getOrientation().set((Provider)$extension.getOrientation());
        task.getLinkText().set((Provider)$extension.getLinkText());
        task.getShowFullPath().set((Provider)$extension.getShowFullPath());
        task.getExcludedConfigurationsRegex().set((Provider)$extension.getExcludedConfigurationsRegex());
        task.getExcludedModulesRegex().set((Provider)$extension.getExcludedModulesRegex());
        task.getSetStyleByModuleType().set((Provider)$extension.getSetStyleByModuleType());
        task.getRootModulesRegex().set((Provider)$extension.getRootModulesRegex());
        task.getGraphConfigs().set((Provider)$extension.getGraphConfigs());
        task.getProjectDirectory$modulegraph().set((Object)$project.getLayout().getProjectDirectory());
        task.getStrictMode().set((Provider)$extension.getStrictMode());
        task.getNestingEnabled().set((Provider)$extension.getNestingEnabled());
        Intrinsics.checkNotNull((Object)((Object)task));
        GraphConfig primaryGraphConfig = this$0.getPrimaryGraphConfig(task);
        List additionalGraphConfigs = (List)task.getGraphConfigs().getOrElse((Object)CollectionsKt.emptyList());
        Collection collection2 = CollectionsKt.listOfNotNull((Object)primaryGraphConfig);
        Intrinsics.checkNotNull((Object)additionalGraphConfigs);
        List allGraphConfigs = CollectionsKt.plus((Collection)collection2, (Iterable)additionalGraphConfigs);
        if (allGraphConfigs.isEmpty()) {
            throw new IllegalStateException("No valid graph configs were found!\nMake sure to set up either the primary graph, or add additional graphs.".toString());
        }
        Set allProjects = $project.getAllprojects();
        Intrinsics.checkNotNull((Object)allProjects);
        Iterable $this$map$iv = allProjects;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Project project = (Project)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        List allProjectPaths = (List)destination$iv$iv;
        GradleProjectQuerier projectQuerier = new GradleProjectQuerier(allProjects);
        Iterable $this$map$iv2 = allGraphConfigs;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void config;
            GraphConfig graphConfig = (GraphConfig)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)config);
            Map<Module, List<Module>> projectGraph = ProjectParser.INSTANCE.parseProjectGraph$modulegraph(allProjectPaths, (GraphConfig)config, projectQuerier);
            collection.add(new GraphParseResult(projectGraph, (GraphConfig)config));
        }
        List results = (List)destination$iv$iv2;
        task.getGraphModels$modulegraph().set((Iterable)results);
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

