/*
 * Decompiled with CFR 0.152.
 */
package dev.iurysouza.modulegraph.gradle;

import dev.iurysouza.modulegraph.LinkText;
import dev.iurysouza.modulegraph.Mermaid;
import dev.iurysouza.modulegraph.Orientation;
import dev.iurysouza.modulegraph.ReadmeWriter;
import dev.iurysouza.modulegraph.Theme;
import dev.iurysouza.modulegraph.model.GraphConfig;
import dev.iurysouza.modulegraph.model.GraphParseResult;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010,\u001a\u00020-H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0014\u0010\u001c\u001a\u00020\u001d8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0007R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0007R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0007R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0007\u00a8\u0006."}, d2={"Ldev/iurysouza/modulegraph/gradle/CreateModuleGraphTask;", "Lorg/gradle/api/DefaultTask;", "()V", "excludedConfigurationsRegex", "Lorg/gradle/api/provider/Property;", "", "getExcludedConfigurationsRegex", "()Lorg/gradle/api/provider/Property;", "excludedModulesRegex", "getExcludedModulesRegex", "focusedModulesRegex", "getFocusedModulesRegex", "graphConfigs", "Lorg/gradle/api/provider/ListProperty;", "Ldev/iurysouza/modulegraph/model/GraphConfig;", "getGraphConfigs", "()Lorg/gradle/api/provider/ListProperty;", "graphModels", "Ldev/iurysouza/modulegraph/model/GraphParseResult;", "getGraphModels$modulegraph", "heading", "getHeading", "linkText", "Ldev/iurysouza/modulegraph/LinkText;", "getLinkText", "orientation", "Ldev/iurysouza/modulegraph/Orientation;", "getOrientation", "projectDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDirectory$modulegraph", "()Lorg/gradle/api/file/DirectoryProperty;", "readmePath", "getReadmePath", "rootModulesRegex", "getRootModulesRegex", "setStyleByModuleType", "", "getSetStyleByModuleType", "showFullPath", "getShowFullPath", "theme", "Ldev/iurysouza/modulegraph/Theme;", "getTheme", "execute", "", "modulegraph"})
@SourceDebugExtension(value={"SMAP\nCreateModuleGraphTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateModuleGraphTask.kt\ndev/iurysouza/modulegraph/gradle/CreateModuleGraphTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n*S KotlinDebug\n*F\n+ 1 CreateModuleGraphTask.kt\ndev/iurysouza/modulegraph/gradle/CreateModuleGraphTask\n*L\n130#1:151,2\n*E\n"})
public abstract class CreateModuleGraphTask
extends DefaultTask {
    public CreateModuleGraphTask() {
        this.setGroup("Reporting");
        this.setDescription("Creates a mermaid dependency graph for the project");
    }

    @Input
    @Option(option="readmePath", description="The readme file path, for the primary graph")
    @Optional
    @NotNull
    public abstract Property<String> getReadmePath();

    @Input
    @Option(option="heading", description="The heading where the graph will be appended, for the primary graph")
    @Optional
    @NotNull
    public abstract Property<String> getHeading();

    @Input
    @Option(option="theme", description="The mermaid theme")
    @Optional
    @NotNull
    public abstract Property<Theme> getTheme();

    @Input
    @Option(option="focusedModulesRegex", description="A Regex to match modules that should be focused.")
    @Optional
    @NotNull
    public abstract Property<String> getFocusedModulesRegex();

    @Input
    @Option(option="orientation", description="The flowchart orientation")
    @Optional
    @NotNull
    public abstract Property<Orientation> getOrientation();

    @Input
    @Option(option="showFullPath", description="Whether to show the modules full path")
    @Optional
    @NotNull
    public abstract Property<Boolean> getShowFullPath();

    @Input
    @Option(option="linkText", description="Whether to add information as text on links in graph")
    @Optional
    @NotNull
    public abstract Property<LinkText> getLinkText();

    @Input
    @Option(option="excludedConfigurationsRegex", description="A Regex to match configurations that should removed")
    @Optional
    @NotNull
    public abstract Property<String> getExcludedConfigurationsRegex();

    @Input
    @Option(option="excludedModulesRegex", description="A Regex to match modules that should removed")
    @Optional
    @NotNull
    public abstract Property<String> getExcludedModulesRegex();

    @Input
    @Option(option="rootModulesRegex", description="A Regex to match root modules")
    @Optional
    @NotNull
    public abstract Property<String> getRootModulesRegex();

    @Input
    @Option(option="graphConfigs", description="A list of configs, each of which will generate a separate graph")
    @Optional
    @NotNull
    public abstract ListProperty<GraphConfig> getGraphConfigs();

    @Input
    @Option(option="setStyleByModuleType", description="Whether to customize the module by the plugin type")
    @Optional
    @NotNull
    public abstract Property<Boolean> getSetStyleByModuleType();

    @Input
    @Option(option="graphModels", description="The produced graph models")
    @NotNull
    public abstract ListProperty<GraphParseResult> getGraphModels$modulegraph();

    @OutputDirectory
    @Option(option="projectDirectory", description="The root project directory")
    @NotNull
    public abstract DirectoryProperty getProjectDirectory$modulegraph();

    @TaskAction
    public final void execute() {
        Object object;
        Object object2 = this;
        try {
            CreateModuleGraphTask $this$execute_u24lambda_u241 = object2;
            boolean bl = false;
            List list = (List)$this$execute_u24lambda_u241.getGraphModels$modulegraph().getOrNull();
            if (list == null) {
                throw new IllegalStateException("Graph models have not been computed. This is a bug in the plugin - please report it!".toString());
            }
            List list2 = list;
            Intrinsics.checkNotNull((Object)list2);
            List results = list2;
            Iterable $this$forEach$iv = results;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Directory directory;
                GraphParseResult result = (GraphParseResult)element$iv;
                boolean bl2 = false;
                GraphConfig config = result.getConfig();
                Intrinsics.checkNotNull((Object)result);
                String mermaidGraph = Mermaid.INSTANCE.generateGraph(result);
                if ((Directory)$this$execute_u24lambda_u241.getProjectDirectory$modulegraph().getOrNull() == null) {
                    throw new IllegalStateException("projectDirectory is not set".toString());
                }
                Intrinsics.checkNotNull((Object)directory);
                Directory root = directory;
                RegularFile readmeFile = root.file(config.getReadmePath());
                String string = config.getHeading();
                File file = readmeFile.getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                Logger logger = $this$execute_u24lambda_u241.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                ReadmeWriter.INSTANCE.appendOrOverwriteGraph(mermaidGraph, string, file, logger);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            this.getLogger().log(LogLevel.ERROR, ((Throwable)it).getMessage(), (Throwable)it);
            throw it;
        }
    }
}

