/*
 * Decompiled with CFR 0.152.
 */
package dev.icerock.moko.network.errors;

import dev.icerock.moko.errors.mappers.ConditionPair;
import dev.icerock.moko.errors.mappers.ExceptionMappersStorage;
import dev.icerock.moko.network.IsSSLExceptionKt;
import dev.icerock.moko.network.SSLExceptionType;
import dev.icerock.moko.network.errors.HttpNetworkErrorsTexts;
import dev.icerock.moko.network.errors.NetworkErorrsTexts;
import dev.icerock.moko.network.errors.NetworkExceptionMappersKt;
import dev.icerock.moko.network.errors.SSLNetworkErrorsTexts;
import dev.icerock.moko.network.exceptions.ErrorException;
import dev.icerock.moko.network.exceptions.ValidationException;
import dev.icerock.moko.resources.StringResource;
import dev.icerock.moko.resources.desc.RawStringDesc;
import dev.icerock.moko.resources.desc.ResourceFormattedStringDescKt;
import dev.icerock.moko.resources.desc.StringDesc;
import dev.icerock.moko.resources.desc.StringDescKt;
import io.ktor.http.HttpStatusCode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"INTERNAL_SERVER_ERROR_CODE_MAX", "", "getNetworkErrorExceptionStringDescMapper", "Ldev/icerock/moko/resources/desc/StringDesc;", "errorException", "Ldev/icerock/moko/network/exceptions/ErrorException;", "httpNetworkErrorsTexts", "Ldev/icerock/moko/network/errors/HttpNetworkErrorsTexts;", "getSSLExceptionStringDescMapper", "sslException", "", "sslNetworkErrorsTexts", "Ldev/icerock/moko/network/errors/SSLNetworkErrorsTexts;", "validationExceptionStringDescMapper", "exception", "Ldev/icerock/moko/network/exceptions/ValidationException;", "registerAllNetworkMappers", "Ldev/icerock/moko/errors/mappers/ExceptionMappersStorage;", "errorsTexts", "Ldev/icerock/moko/network/errors/NetworkErorrsTexts;", "network-errors_debug"})
public final class NetworkExceptionMappersKt {
    private static final int INTERNAL_SERVER_ERROR_CODE_MAX = 599;

    @NotNull
    public static final ExceptionMappersStorage registerAllNetworkMappers(@NotNull ExceptionMappersStorage $this$registerAllNetworkMappers, @NotNull NetworkErorrsTexts errorsTexts) {
        Function1 mapper$iv;
        Function1 condition$iv;
        ExceptionMappersStorage this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerAllNetworkMappers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorsTexts, (String)"errorsTexts");
        ExceptionMappersStorage exceptionMappersStorage = $this$registerAllNetworkMappers;
        Function1 function1 = registerAllNetworkMappers.1.INSTANCE;
        Function1 function12 = (Function1)new Function1<Throwable, StringDesc>(errorsTexts){
            final /* synthetic */ NetworkErorrsTexts $errorsTexts;
            {
                this.$errorsTexts = $errorsTexts;
                super(1);
            }

            @NotNull
            public final StringDesc invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (StringDesc)StringDescKt.desc((StringResource)this.$errorsTexts.getNetworkConnectionErrorText());
            }
        };
        boolean $i$f$condition = false;
        this_$iv = this_$iv.register(Reflection.getOrCreateKotlinClass(StringDesc.class), new ConditionPair(condition$iv, mapper$iv));
        condition$iv = registerAllNetworkMappers.3.INSTANCE;
        mapper$iv = (Function1)new Function1<Throwable, StringDesc>(errorsTexts){
            final /* synthetic */ NetworkErorrsTexts $errorsTexts;
            {
                this.$errorsTexts = $errorsTexts;
                super(1);
            }

            @NotNull
            public final StringDesc invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NetworkExceptionMappersKt.access$getSSLExceptionStringDescMapper(it, this.$errorsTexts.getSslNetworkErrorsTexts());
            }
        };
        $i$f$condition = false;
        this_$iv = this_$iv.register(Reflection.getOrCreateKotlinClass(StringDesc.class), new ConditionPair(condition$iv, mapper$iv));
        condition$iv = registerAllNetworkMappers.5.INSTANCE;
        mapper$iv = (Function1)new Function1<Throwable, StringDesc>(errorsTexts){
            final /* synthetic */ NetworkErorrsTexts $errorsTexts;
            {
                this.$errorsTexts = $errorsTexts;
                super(1);
            }

            @NotNull
            public final StringDesc invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (StringDesc)StringDescKt.desc((StringResource)this.$errorsTexts.getSerializationErrorText());
            }
        };
        $i$f$condition = false;
        this_$iv = this_$iv.register(Reflection.getOrCreateKotlinClass(StringDesc.class), new ConditionPair(condition$iv, mapper$iv));
        Function1 mapper$iv2 = (Function1)new Function1<ErrorException, StringDesc>(errorsTexts){
            final /* synthetic */ NetworkErorrsTexts $errorsTexts;
            {
                this.$errorsTexts = $errorsTexts;
                super(1);
            }

            @NotNull
            public final StringDesc invoke(@NotNull ErrorException it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NetworkExceptionMappersKt.access$getNetworkErrorExceptionStringDescMapper(it, this.$errorsTexts.getHttpNetworkErrorsTexts());
            }
        };
        boolean $i$f$register = false;
        this_$iv = this_$iv.register(Reflection.getOrCreateKotlinClass(StringDesc.class), Reflection.getOrCreateKotlinClass(ErrorException.class), mapper$iv2);
        mapper$iv2 = registerAllNetworkMappers.8.INSTANCE;
        $i$f$register = false;
        return this_$iv.register(Reflection.getOrCreateKotlinClass(StringDesc.class), Reflection.getOrCreateKotlinClass(ValidationException.class), mapper$iv2);
    }

    private static final StringDesc getNetworkErrorExceptionStringDescMapper(ErrorException errorException, HttpNetworkErrorsTexts httpNetworkErrorsTexts) {
        StringDesc stringDesc;
        int httpStatusCode = errorException.getHttpStatusCode();
        if (errorException.isUnauthorized()) {
            stringDesc = (StringDesc)StringDescKt.desc((StringResource)httpNetworkErrorsTexts.getUnauthorizedErrorText());
        } else if (errorException.isNotFound()) {
            stringDesc = (StringDesc)StringDescKt.desc((StringResource)httpNetworkErrorsTexts.getNotFoundErrorText());
        } else if (errorException.isAccessDenied()) {
            stringDesc = (StringDesc)StringDescKt.desc((StringResource)httpNetworkErrorsTexts.getAccessDeniedErrorText());
        } else if (httpStatusCode >= HttpStatusCode.Companion.getInternalServerError().getValue() && httpStatusCode <= 599) {
            Object[] objectArray = new Object[]{httpStatusCode};
            stringDesc = (StringDesc)ResourceFormattedStringDescKt.ResourceFormatted((StringDesc.Companion)StringDesc.Companion, (StringResource)httpNetworkErrorsTexts.getInternalServerErrorText(), (Object[])objectArray);
        } else {
            RawStringDesc rawStringDesc;
            String string2 = errorException.getDescription();
            RawStringDesc rawStringDesc2 = rawStringDesc = string2 == null ? null : StringDescKt.desc((String)string2);
            if (rawStringDesc == null) {
                ExceptionMappersStorage this_$iv = ExceptionMappersStorage.INSTANCE;
                boolean $i$f$getFallbackValue = false;
                stringDesc = (StringDesc)this_$iv.getFallbackValue(Reflection.getOrCreateKotlinClass(StringDesc.class));
            } else {
                stringDesc = (StringDesc)rawStringDesc;
            }
        }
        return stringDesc;
    }

    private static final StringDesc getSSLExceptionStringDescMapper(Throwable sslException, SSLNetworkErrorsTexts sslNetworkErrorsTexts) {
        StringDesc stringDesc;
        SSLExceptionType sSLExceptionType = IsSSLExceptionKt.getSSLExceptionType((Throwable)sslException);
        int n = sSLExceptionType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[sSLExceptionType.ordinal()];
        switch (n) {
            case 1: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getSecureConnectionFailed());
                break;
            }
            case 2: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getServerCertificateHasBadDate());
                break;
            }
            case 3: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getServerCertificateUntrusted());
                break;
            }
            case 4: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getServerCertificateHasUnknownRoot());
                break;
            }
            case 5: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getServerCertificateNotYetValid());
                break;
            }
            case 6: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getClientCertificateRejected());
                break;
            }
            case 7: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getClientCertificateRequired());
                break;
            }
            case 8: {
                stringDesc = (StringDesc)StringDescKt.desc((StringResource)sslNetworkErrorsTexts.getCannotLoadFromNetwork());
                break;
            }
            default: {
                ExceptionMappersStorage this_$iv = ExceptionMappersStorage.INSTANCE;
                boolean $i$f$getFallbackValue = false;
                stringDesc = (StringDesc)this_$iv.getFallbackValue(Reflection.getOrCreateKotlinClass(StringDesc.class));
            }
        }
        return stringDesc;
    }

    private static final StringDesc validationExceptionStringDescMapper(ValidationException exception) {
        return (StringDesc)StringDescKt.desc((String)CollectionsKt.joinToString$default((Iterable)exception.getErrors(), (CharSequence)". ", null, null, (int)0, null, (Function1)validationExceptionStringDescMapper.1.INSTANCE, (int)30, null));
    }

    public static final /* synthetic */ StringDesc access$getSSLExceptionStringDescMapper(Throwable sslException, SSLNetworkErrorsTexts sslNetworkErrorsTexts) {
        return NetworkExceptionMappersKt.getSSLExceptionStringDescMapper(sslException, sslNetworkErrorsTexts);
    }

    public static final /* synthetic */ StringDesc access$getNetworkErrorExceptionStringDescMapper(ErrorException errorException, HttpNetworkErrorsTexts httpNetworkErrorsTexts) {
        return NetworkExceptionMappersKt.getNetworkErrorExceptionStringDescMapper(errorException, httpNetworkErrorsTexts);
    }

    public static final /* synthetic */ StringDesc access$validationExceptionStringDescMapper(ValidationException exception) {
        return NetworkExceptionMappersKt.validationExceptionStringDescMapper(exception);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SSLExceptionType.values().length];
            nArray[SSLExceptionType.SecureConnectionFailed.ordinal()] = 1;
            nArray[SSLExceptionType.ServerCertificateHasBadDate.ordinal()] = 2;
            nArray[SSLExceptionType.ServerCertificateUntrusted.ordinal()] = 3;
            nArray[SSLExceptionType.ServerCertificateHasUnknownRoot.ordinal()] = 4;
            nArray[SSLExceptionType.ServerCertificateNotYetValid.ordinal()] = 5;
            nArray[SSLExceptionType.ClientCertificateRejected.ordinal()] = 6;
            nArray[SSLExceptionType.ClientCertificateRequired.ordinal()] = 7;
            nArray[SSLExceptionType.CannotLoadFromNetwork.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

