/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotatedAbstractModel;
import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassRefSignatureModel;
import dev.hilla.parser.models.ReflectionSignatureModel;
import dev.hilla.parser.models.TypeArgumentModel;
import dev.hilla.parser.utils.AnnotatedOwnerUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class ClassRefSignatureReflectionModel<T extends AnnotatedElement>
extends ClassRefSignatureModel
implements ReflectionSignatureModel {
    protected final T origin;

    ClassRefSignatureReflectionModel(T origin) {
        this.origin = origin;
    }

    public T get() {
        return this.origin;
    }

    protected abstract Class<?> getOriginClassInfo();

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return ClassRefSignatureReflectionModel.processAnnotations(this.origin.getAnnotations());
    }

    @Override
    protected ClassInfoModel prepareClassInfo() {
        return ClassInfoModel.of(this.getOriginClassInfo());
    }

    @Override
    protected List<TypeArgumentModel> prepareTypeArguments() {
        return List.of();
    }

    static abstract class Annotated<T extends AnnotatedType>
    extends ClassRefSignatureReflectionModel<T> {
        protected final List<Annotation[]> ownedAnnotations;
        protected final int ownerIndex;

        Annotated(T origin, List<Annotation[]> ownedAnnotations, int ownerIndex) {
            super(origin);
            this.ownedAnnotations = ownedAnnotations;
            this.ownerIndex = ownerIndex;
        }

        public static Annotated<?> of(AnnotatedType origin) {
            return Annotated.of(origin, AnnotatedOwnerUtils.getAllOwnersAnnotations((AnnotatedType)origin), 0);
        }

        private static Annotated<?> of(AnnotatedType origin, List<Annotation[]> annotations, int ownerIndex) {
            return origin instanceof AnnotatedParameterizedType ? new Regular((AnnotatedParameterizedType)origin, annotations, ownerIndex) : new AnnotatedBare(origin, annotations, ownerIndex);
        }

        @Override
        protected List<AnnotationInfoModel> prepareAnnotations() {
            return AnnotatedAbstractModel.processAnnotations(this.ownedAnnotations.get(this.ownerIndex));
        }

        @Override
        protected Optional<ClassRefSignatureModel> prepareOwner() {
            AnnotatedType owner = ((AnnotatedType)this.origin).getAnnotatedOwnerType();
            return owner != null ? Optional.of(Annotated.of(owner, this.ownedAnnotations, this.ownerIndex + 1)) : Optional.empty();
        }
    }

    static final class Regular
    extends Annotated<AnnotatedParameterizedType> {
        private Regular(AnnotatedParameterizedType origin, List<Annotation[]> annotations, int ownerIndex) {
            super(origin, annotations, ownerIndex);
        }

        @Override
        protected Class<?> getOriginClassInfo() {
            return (Class)((ParameterizedType)((AnnotatedParameterizedType)this.origin).getType()).getRawType();
        }

        @Override
        protected List<TypeArgumentModel> prepareTypeArguments() {
            return Arrays.stream(((AnnotatedParameterizedType)this.origin).getAnnotatedActualTypeArguments()).map(TypeArgumentModel::of).collect(Collectors.toList());
        }
    }

    static final class Bare
    extends ClassRefSignatureReflectionModel<Class<?>> {
        Bare(Class<?> origin) {
            super(origin);
        }

        @Override
        protected Class<?> getOriginClassInfo() {
            return (Class)this.origin;
        }

        @Override
        protected Optional<ClassRefSignatureModel> prepareOwner() {
            return Optional.empty();
        }
    }

    static final class AnnotatedBare
    extends Annotated<AnnotatedType> {
        AnnotatedBare(AnnotatedType origin, List<Annotation[]> annotations, int ownerIndex) {
            super(origin, annotations, ownerIndex);
        }

        @Override
        protected Class<?> getOriginClassInfo() {
            return (Class)((AnnotatedType)this.origin).getType();
        }
    }
}

