/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.AbstractJsonNode;
import dev.harrel.jsonschema.providers.MapUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class GsonNode
extends AbstractJsonNode<JsonElement> {
    private GsonNode(JsonElement node, String jsonPointer) {
        super(Objects.requireNonNull(node), jsonPointer);
    }

    public GsonNode(JsonElement node) {
        this(node, "");
    }

    @Override
    List<JsonNode> createArray() {
        JsonArray array = ((JsonElement)this.node).getAsJsonArray();
        ArrayList<JsonNode> result = new ArrayList<JsonNode>(array.size());
        int i = 0;
        for (JsonElement elem : array) {
            result.add(new GsonNode(elem, this.jsonPointer + "/" + i++));
        }
        return result;
    }

    @Override
    Map<String, JsonNode> createObject() {
        Set objectMap = ((JsonElement)this.node).getAsJsonObject().entrySet();
        HashMap<String, JsonNode> result = MapUtil.newHashMap(objectMap.size());
        for (Map.Entry entry : objectMap) {
            result.put((String)entry.getKey(), new GsonNode((JsonElement)entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return result;
    }

    @Override
    SimpleType computeNodeType(JsonElement node) {
        if (node.isJsonNull()) {
            return SimpleType.NULL;
        }
        if (node.isJsonArray()) {
            return SimpleType.ARRAY;
        }
        if (node.isJsonObject()) {
            return SimpleType.OBJECT;
        }
        JsonPrimitive jsonPrimitive = node.getAsJsonPrimitive();
        if (jsonPrimitive.isBoolean()) {
            this.rawNode = node.getAsBoolean();
            return SimpleType.BOOLEAN;
        }
        if (jsonPrimitive.isString()) {
            this.rawNode = node.getAsString();
            return SimpleType.STRING;
        }
        this.rawNode = jsonPrimitive.getAsBigDecimal();
        if (GsonNode.canConvertToInteger((BigDecimal)this.rawNode)) {
            return SimpleType.INTEGER;
        }
        return SimpleType.NUMBER;
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final JsonParser jsonParser = new JsonParser();

        @Override
        public GsonNode wrap(Object node) {
            if (node instanceof GsonNode) {
                return new GsonNode((JsonElement)((GsonNode)node).node);
            }
            if (node instanceof JsonElement) {
                return new GsonNode((JsonElement)node);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of com.google.gson.JsonElement");
        }

        @Override
        public GsonNode create(String rawJson) {
            return new GsonNode(this.jsonParser.parse(rawJson));
        }
    }
}

