/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.MetaSchemaData;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SpecificationVersion;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;

public final class SchemaParsingContext {
    private final MetaSchemaData metaSchemaData;
    private final SchemaRegistry schemaRegistry;
    private final Map<String, JsonNode> currentSchemaObject;
    private final Deque<URI> uriStack;

    private SchemaParsingContext(MetaSchemaData metaSchemaData, SchemaRegistry schemaRegistry, Map<String, JsonNode> currentSchemaObject, Deque<URI> uriStack) {
        this.metaSchemaData = metaSchemaData;
        this.schemaRegistry = schemaRegistry;
        this.currentSchemaObject = currentSchemaObject;
        this.uriStack = uriStack;
    }

    SchemaParsingContext(MetaSchemaData metaSchemaData, URI baseUri, SchemaRegistry schemaRegistry, Map<String, JsonNode> currentSchemaObject) {
        this(metaSchemaData, schemaRegistry, currentSchemaObject, new ArrayDeque<URI>(Collections.singletonList(baseUri)));
    }

    SchemaParsingContext forChild(MetaSchemaData metaSchemaData, Map<String, JsonNode> currentSchemaObject, URI parentUri) {
        ArrayDeque<URI> newUriStack = new ArrayDeque<URI>(this.uriStack);
        newUriStack.push(parentUri);
        return new SchemaParsingContext(metaSchemaData, this.schemaRegistry, currentSchemaObject, newUriStack);
    }

    SchemaParsingContext forChild(Map<String, JsonNode> currentSchemaObject) {
        return new SchemaParsingContext(this.metaSchemaData, this.schemaRegistry, currentSchemaObject, this.uriStack);
    }

    MetaSchemaData getMetaValidationData() {
        return this.metaSchemaData;
    }

    SpecificationVersion getSpecificationVersion() {
        return this.metaSchemaData.dialect.getSpecificationVersion();
    }

    URI getGrandparentUri() {
        Iterator<URI> it = this.uriStack.iterator();
        URI parent = it.next();
        if (it.hasNext()) {
            return it.next();
        }
        return parent;
    }

    URI getBaseUri() {
        return this.uriStack.getLast();
    }

    public URI getParentUri() {
        return this.uriStack.getFirst();
    }

    public String getAbsoluteUri(JsonNode node) {
        return this.getAbsoluteUri(node.getJsonPointer());
    }

    public String getAbsoluteUri(String jsonPointer) {
        return this.getBaseUri() + "#" + jsonPointer;
    }

    public Map<String, JsonNode> getCurrentSchemaObject() {
        return Collections.unmodifiableMap(this.currentSchemaObject);
    }

    CompoundUri getCompoundUri(JsonNode node) {
        return new CompoundUri(this.getBaseUri(), node.getJsonPointer());
    }
}

