/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;

class IfThenElseEvaluator
implements Evaluator {
    private final CompoundUri ifRef;
    private final CompoundUri thenRef;
    private final CompoundUri elseRef;

    IfThenElseEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.ifRef = ctx.getCompoundUri(node);
        JsonNode thenNode = ctx.getCurrentSchemaObject().get("then");
        this.thenRef = thenNode == null ? null : ctx.getCompoundUri(thenNode);
        JsonNode elseNode = ctx.getCurrentSchemaObject().get("else");
        this.elseRef = elseNode == null ? null : ctx.getCompoundUri(elseNode);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (ctx.resolveInternalRefAndValidate(this.ifRef, node)) {
            boolean valid = this.thenRef == null || ctx.resolveInternalRefAndValidate(this.thenRef, node);
            return valid ? Evaluator.Result.success() : Evaluator.Result.failure("Value matches against schema from 'if' but does not match against schema from 'then'");
        }
        boolean valid = this.elseRef == null || ctx.resolveInternalRefAndValidate(this.elseRef, node);
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure("Value does not match against schema from 'if' and 'else'");
    }
}

