/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.math.BigDecimal;

class ExclusiveMaximumEvaluator
implements Evaluator {
    private final BigDecimal max;

    ExclusiveMaximumEvaluator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.max = node.asNumber();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return Evaluator.Result.success();
        }
        if (node.asNumber().compareTo(this.max) < 0) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(() -> String.format("%s is greater or equal to %s", node.asNumber(), this.max));
    }
}

