/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeUtil;
import dev.harrel.jsonschema.providers.InternalProviderUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class EnumEvaluator
implements Evaluator {
    private final Set<JsonNode> enumNodes;
    private final String failMessage;
    private final boolean canUseNativeEquals;

    EnumEvaluator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.enumNodes = Collections.unmodifiableSet(new LinkedHashSet<JsonNode>(node.asArray()));
        List printList = this.enumNodes.stream().map(JsonNode::toPrintableString).collect(Collectors.toList());
        this.failMessage = String.format("Expected any of [%s]", printList);
        this.canUseNativeEquals = InternalProviderUtil.canUseNativeEquals(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (this.canUseNativeEquals && InternalProviderUtil.canUseNativeEquals(node)) {
            return this.enumNodes.contains(node) ? Evaluator.Result.success() : Evaluator.Result.failure(this.failMessage);
        }
        for (JsonNode enumNode : this.enumNodes) {
            if (!JsonNodeUtil.equals(enumNode, node)) continue;
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(this.failMessage);
    }
}

