/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;

class MinItemsEvaluator
implements Evaluator {
    private final int minItems;

    MinItemsEvaluator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.minItems = node.asInteger().intValueExact();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        if (node.asArray().size() >= this.minItems) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(String.format("Array has less than %d items", this.minItems));
    }
}

