/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collection;

class MaxContainsEvaluator
implements Evaluator {
    private final int max;

    MaxContainsEvaluator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.max = node.asInteger().intValueExact();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        int containsCount;
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        Object containsAnnotation = ctx.getSiblingAnnotation("contains", node.getJsonPointer());
        int n = containsCount = containsAnnotation instanceof Collection ? ((Collection)containsAnnotation).size() : 0;
        if (containsCount <= this.max) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(String.format("Array contains more than %d matching items", this.max));
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

