/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.AnnotationTree;
import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.Error;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class EvaluationContext {
    private final JsonNodeFactory jsonNodeFactory;
    private final JsonParser jsonParser;
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;
    private final Deque<URI> dynamicScope = new ArrayDeque<URI>();
    private final Deque<RefStackItem> refStack = new ArrayDeque<RefStackItem>();
    private final LinkedList<String> evaluationStack = new LinkedList();
    private final AnnotationTree annotationTree = new AnnotationTree();
    private final List<Error> errors = new ArrayList<Error>();

    EvaluationContext(JsonNodeFactory jsonNodeFactory, JsonParser jsonParser, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.jsonParser = Objects.requireNonNull(jsonParser);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
        this.evaluationStack.push("");
    }

    public boolean resolveRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        Schema schema = this.resolveSchema(compoundUri);
        if (schema == null) {
            throw new SchemaNotFoundException(compoundUri);
        }
        return this.validateAgainstRefSchema(schema, node);
    }

    public boolean resolveDynamicRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveDynamicRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveDynamicRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        Schema schema = this.resolveDynamicSchema(compoundUri);
        if (schema == null) {
            throw new SchemaNotFoundException(compoundUri);
        }
        return this.validateAgainstRefSchema(schema, node);
    }

    public boolean resolveRecursiveRefAndValidate(String schemaRef, JsonNode node) {
        Schema schema = this.resolveRecursiveSchema();
        if (schema == null) {
            throw new SchemaNotFoundException(CompoundUri.fromString(schemaRef));
        }
        return this.validateAgainstRefSchema(schema, node);
    }

    public boolean resolveInternalRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveInternalRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveInternalRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        Schema schema = this.schemaRegistry.get(compoundUri);
        if (schema == null) {
            throw new SchemaNotFoundException(compoundUri);
        }
        return this.validateAgainstSchema(schema, node);
    }

    List<Error> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    Object getSiblingAnnotation(String sibling, String instanceLocation) {
        for (Annotation annotation : this.annotationTree.getNode((String)this.evaluationStack.get((int)1)).annotations) {
            if (!instanceLocation.equals(annotation.getInstanceLocation()) || !sibling.equals(annotation.getKeyword())) continue;
            return annotation.getAnnotation();
        }
        return null;
    }

    AnnotationTree getAnnotationTree() {
        return this.annotationTree;
    }

    Set<String> calculateEvaluatedInstancesFromParent() {
        String parentPath = this.evaluationStack.get(1);
        String correctedParentPath = UriUtil.getJsonPointerParent(this.evaluationStack.element());
        List<Annotation> annotations = this.annotationTree.getNode(parentPath).toList();
        HashSet<String> all = new HashSet<String>(annotations.size() + this.errors.size());
        for (Annotation annotation : annotations) {
            if (!annotation.getEvaluationPath().startsWith(correctedParentPath)) continue;
            all.add(annotation.getInstanceLocation());
        }
        for (Error error : this.errors) {
            if (!error.getEvaluationPath().startsWith(correctedParentPath)) continue;
            all.add(error.getInstanceLocation());
        }
        return all;
    }

    boolean validateAgainstSchema(Schema schema, JsonNode node) {
        boolean outOfDynamicScope;
        boolean bl = outOfDynamicScope = !schema.getParentUri().equals(this.dynamicScope.peek());
        if (outOfDynamicScope) {
            this.dynamicScope.push(schema.getParentUri());
        }
        String parentSchemaLocation = this.evaluationStack.size() > 1 ? this.evaluationStack.get(1) : null;
        AnnotationTree.Node treeNode = this.annotationTree.createIfAbsent(parentSchemaLocation, this.evaluationStack.element());
        int nodesBefore = treeNode.nodes.size();
        int annotationsBefore = treeNode.annotations.size();
        boolean valid = true;
        for (EvaluatorWrapper evaluator : schema.getEvaluators()) {
            String evaluationPath = this.resolveEvaluationPath(evaluator);
            this.evaluationStack.push(evaluationPath);
            int errorsBefore = this.errors.size();
            Evaluator.Result result = evaluator.evaluate(this, node);
            if (result.isValid()) {
                this.errors.subList(errorsBefore, this.errors.size()).clear();
                Annotation annotation = new Annotation(evaluationPath, schema.getSchemaLocation(), node.getJsonPointer(), evaluator.getKeyword(), result.getAnnotation());
                treeNode.annotations.add(annotation);
            } else {
                valid = false;
                this.errors.add(new Error(evaluationPath, schema.getSchemaLocation(), node.getJsonPointer(), evaluator.getKeyword(), result.getError()));
            }
            this.evaluationStack.pop();
        }
        if (!valid) {
            treeNode.nodes.subList(nodesBefore, treeNode.nodes.size()).clear();
            treeNode.annotations.subList(annotationsBefore, treeNode.annotations.size()).clear();
        }
        if (outOfDynamicScope) {
            this.dynamicScope.pop();
        }
        return valid;
    }

    private boolean validateAgainstRefSchema(Schema schema, JsonNode node) {
        this.refStack.push(new RefStackItem(schema.getSchemaLocationFragment(), this.evaluationStack.peek()));
        boolean valid = this.validateAgainstSchema(schema, node);
        this.refStack.pop();
        return valid;
    }

    private Schema resolveSchema(CompoundUri compoundUri) {
        Schema schema = this.schemaRegistry.get(compoundUri);
        if (schema != null) {
            return schema;
        }
        schema = this.schemaRegistry.getDynamic(compoundUri);
        if (schema != null) {
            return schema;
        }
        return this.resolveExternalSchema(compoundUri);
    }

    private Schema resolveDynamicSchema(CompoundUri compoundUri) {
        Schema staticSchema = this.schemaRegistry.get(compoundUri);
        if (staticSchema != null) {
            return staticSchema;
        }
        Iterator<URI> it = this.dynamicScope.descendingIterator();
        while (it.hasNext()) {
            Schema schema = this.schemaRegistry.getDynamic(new CompoundUri(it.next(), compoundUri.fragment));
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    private Schema resolveRecursiveSchema() {
        Schema schema = this.schemaRegistry.get(this.dynamicScope.element());
        for (URI uri : this.dynamicScope) {
            Schema recursedSchema = this.schemaRegistry.getDynamic(uri);
            if (recursedSchema == null) {
                return schema;
            }
            schema = recursedSchema;
        }
        return schema;
    }

    private String resolveEvaluationPath(EvaluatorWrapper evaluator) {
        if (this.refStack.isEmpty()) {
            return evaluator.getKeywordPath();
        }
        RefStackItem refItem = this.refStack.peek();
        String evaluationPathPart = evaluator.getKeywordPath().substring(refItem.schemaLocation.length());
        return refItem.evaluationPath + evaluationPathPart;
    }

    private Schema resolveExternalSchema(CompoundUri compoundUri) {
        if (this.schemaRegistry.get(compoundUri.uri) != null) {
            return null;
        }
        return this.schemaResolver.resolve(compoundUri.uri.toString()).toJsonNode(this.jsonNodeFactory).map(node -> {
            this.jsonParser.parseRootSchema(compoundUri.uri, (JsonNode)node);
            return this.resolveSchema(compoundUri);
        }).orElse(null);
    }

    private static class RefStackItem {
        private final String schemaLocation;
        private final String evaluationPath;

        private RefStackItem(String schemaLocation, String evaluationPath) {
            this.schemaLocation = schemaLocation;
            this.evaluationPath = evaluationPath;
        }
    }
}

