/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class EnumEvaluator
implements Evaluator {
    private final List<JsonNode> enumNodes;
    private final String failMessage;

    EnumEvaluator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.enumNodes = Collections.unmodifiableList(node.asArray());
        List printList = this.enumNodes.stream().map(JsonNode::toPrintableString).collect(Collectors.toList());
        this.failMessage = String.format("Expected any of [%s]", printList);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        for (JsonNode enumNode : this.enumNodes) {
            if (!enumNode.isEqualTo(node)) continue;
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(this.failMessage);
    }
}

