/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class DependentRequiredEvaluator
implements Evaluator {
    private final Map<String, List<String>> requiredProperties;

    DependentRequiredEvaluator(JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        this.requiredProperties = DependentRequiredEvaluator.toMap(node.asObject());
    }

    DependentRequiredEvaluator(Map<String, JsonNode> objectNode) {
        this.requiredProperties = DependentRequiredEvaluator.toMap(objectNode);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        Set<String> objectKeys = node.asObject().keySet();
        Set requiredSet = objectKeys.stream().filter(this.requiredProperties::containsKey).map(this.requiredProperties::get).flatMap(Collection::stream).collect(Collectors.toSet());
        if (objectKeys.containsAll(requiredSet)) {
            return Evaluator.Result.success();
        }
        requiredSet.removeAll(objectKeys);
        return Evaluator.Result.failure(String.format("Object does not have some of the required properties [%s]", requiredSet));
    }

    private static Map<String, List<String>> toMap(Map<String, JsonNode> objectNode) {
        return objectNode.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> DependentRequiredEvaluator.toStringList((JsonNode)e.getValue())));
    }

    private static List<String> toStringList(JsonNode node) {
        return Collections.unmodifiableList(node.asArray().stream().map(JsonNode::asString).collect(Collectors.toList()));
    }
}

