/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.SpecificationVersion;
import dev.harrel.jsonschema.VocabularyException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class VocabularyValidator {
    VocabularyValidator() {
    }

    void validateVocabularies(Dialect dialect, Map<String, Boolean> vocabularyObject) {
        if (vocabularyObject == null || dialect.getSpecificationVersion().getOrder() <= SpecificationVersion.DRAFT7.getOrder()) {
            return;
        }
        List missingRequiredVocabularies = dialect.getRequiredVocabularies().stream().filter(vocab -> vocabularyObject.getOrDefault(vocab, false) == false).collect(Collectors.toList());
        if (!missingRequiredVocabularies.isEmpty()) {
            throw new VocabularyException(String.format("Required vocabularies %s were missing or marked optional in $vocabulary object", missingRequiredVocabularies));
        }
        List unsupportedRequiredVocabularies = vocabularyObject.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).filter(vocab -> !dialect.getSupportedVocabularies().contains(vocab)).collect(Collectors.toList());
        if (!unsupportedRequiredVocabularies.isEmpty()) {
            throw new VocabularyException(String.format("Following vocabularies %s are required but not supported", unsupportedRequiredVocabularies));
        }
    }
}

