/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.AbstractEvaluatorFactory;
import dev.harrel.jsonschema.DynamicRefEvaluator;
import dev.harrel.jsonschema.ItemsEvaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.PrefixItemsEvaluator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Draft2020EvaluatorFactory
extends AbstractEvaluatorFactory {
    public Draft2020EvaluatorFactory() {
        super(Draft2020EvaluatorFactory.getIgnoredKeywords(), Draft2020EvaluatorFactory.createEvaluatorMap());
    }

    private static Set<String> getIgnoredKeywords() {
        return new HashSet<String>(Arrays.asList("$id", "$schema", "$anchor", "$dynamicAnchor", "$vocabulary", "$comment", "$defs", "then", "else"));
    }

    private static Map<String, AbstractEvaluatorFactory.EvaluatorInfo> createEvaluatorMap() {
        Map<String, AbstractEvaluatorFactory.EvaluatorInfo> map = Draft2020EvaluatorFactory.createDefaultEvaluatorsMap("https://json-schema.org/draft/2020-12/vocab/core", "https://json-schema.org/draft/2020-12/vocab/applicator", "https://json-schema.org/draft/2020-12/vocab/unevaluated", "https://json-schema.org/draft/2020-12/vocab/validation");
        map.put("$dynamicRef", new AbstractEvaluatorFactory.EvaluatorInfo("https://json-schema.org/draft/2020-12/vocab/core", (ctx, node) -> new DynamicRefEvaluator((JsonNode)node)));
        map.put("items", new AbstractEvaluatorFactory.EvaluatorInfo("https://json-schema.org/draft/2020-12/vocab/applicator", ItemsEvaluator::new));
        map.put("prefixItems", new AbstractEvaluatorFactory.EvaluatorInfo("https://json-schema.org/draft/2020-12/vocab/applicator", PrefixItemsEvaluator::new));
        return map;
    }
}

