/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class AdditionalPropertiesEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    AdditionalPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        String instanceLocation = node.getJsonPointer();
        HashSet props = new HashSet();
        ctx.getSiblingAnnotation("properties", instanceLocation, Set.class).ifPresent(props::addAll);
        ctx.getSiblingAnnotation("patternProperties", instanceLocation, Set.class).ifPresent(props::addAll);
        HashMap<String, JsonNode> toBeProcessed = new HashMap<String, JsonNode>(node.asObject());
        toBeProcessed.keySet().removeAll(props);
        boolean valid = true;
        for (JsonNode propNode : toBeProcessed.values()) {
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, propNode) && valid;
        }
        return valid ? Evaluator.Result.success(Collections.unmodifiableSet(toBeProcessed.keySet())) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

