/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.AnnotationTree;
import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Error;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public final class Validator {
    private final JsonNodeFactory jsonNodeFactory;
    private final SchemaResolver schemaResolver;
    private final SchemaRegistry schemaRegistry;
    private final JsonParser jsonParser;
    private final boolean disabledSchemaValidation;

    Validator(Dialect dialect, EvaluatorFactory evaluatorFactory, JsonNodeFactory jsonNodeFactory, SchemaResolver schemaResolver, boolean disabledSchemaValidation) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
        this.schemaRegistry = new SchemaRegistry();
        this.disabledSchemaValidation = disabledSchemaValidation;
        MetaSchemaValidator metaSchemaValidator = disabledSchemaValidation ? new MetaSchemaValidator.NoOpMetaSchemaValidator(dialect.getSupportedVocabularies()) : new MetaSchemaValidator.DefaultMetaSchemaValidator(dialect, this.jsonNodeFactory, this.schemaRegistry, schemaResolver);
        this.jsonParser = new JsonParser(dialect, evaluatorFactory, this.schemaRegistry, metaSchemaValidator);
    }

    public URI registerSchema(String rawSchema) {
        return this.registerSchema(this.jsonNodeFactory.create(rawSchema));
    }

    public URI registerSchema(Object schemaProviderNode) {
        return this.registerSchema(this.jsonNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(this.generateSchemaUri(), schemaNode);
    }

    public URI registerSchema(URI uri, String rawSchema) {
        return this.registerSchema(uri, this.jsonNodeFactory.create(rawSchema));
    }

    public URI registerSchema(URI uri, Object schemaProviderNode) {
        return this.registerSchema(uri, this.jsonNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(URI uri, JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(uri, schemaNode);
    }

    public Result validate(URI schemaUri, String rawInstance) {
        return this.validate(schemaUri, this.jsonNodeFactory.create(rawInstance));
    }

    public Result validate(URI schemaUri, Object instanceProviderNode) {
        return this.validate(schemaUri, this.jsonNodeFactory.wrap(instanceProviderNode));
    }

    public Result validate(URI schemaUri, JsonNode instanceNode) {
        Schema schema = this.getRootSchema(schemaUri);
        EvaluationContext ctx = this.createNewEvaluationContext(schema);
        boolean valid = ctx.validateAgainstSchema(schema, instanceNode);
        return new Result(valid, ctx);
    }

    private Schema getRootSchema(URI uri) {
        if (UriUtil.hasNonEmptyFragment(uri)) {
            throw new IllegalArgumentException(String.format("Root schema [%s] cannot contain non-empty fragments", uri));
        }
        return (Schema)OptionalUtil.firstPresent(() -> Optional.ofNullable(this.schemaRegistry.get(UriUtil.getUriWithoutFragment(uri))), () -> this.resolveExternalSchema(uri)).orElseThrow(() -> new SchemaNotFoundException(new CompoundUri(uri, "")));
    }

    private Optional<Schema> resolveExternalSchema(URI uri) {
        return this.schemaResolver.resolve(uri.toString()).toJsonNode(this.jsonNodeFactory).map(node -> {
            this.jsonParser.parseRootSchema(uri, (JsonNode)node);
            return this.schemaRegistry.get(uri);
        });
    }

    private URI generateSchemaUri() {
        return URI.create("https://harrel.dev/" + UUID.randomUUID().toString().substring(0, 8));
    }

    private EvaluationContext createNewEvaluationContext(Schema schema) {
        return new EvaluationContext(this.jsonNodeFactory, this.jsonParser, this.schemaRegistry, this.schemaResolver, schema.getActiveVocabularies(), this.disabledSchemaValidation);
    }

    public static final class Result {
        private final boolean valid;
        private final List<Error> errors;
        private final AnnotationTree annotationTree;
        private List<Annotation> annotations;

        Result(boolean valid, EvaluationContext ctx) {
            this.valid = valid;
            this.errors = Collections.unmodifiableList(ctx.getErrors().stream().filter(e -> e.getError() != null).collect(Collectors.toList()));
            this.annotationTree = ctx.getAnnotationTree();
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<Annotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = Collections.unmodifiableList(this.annotationTree.getAllAnnotations().filter(a -> a.getAnnotation() != null).collect(Collectors.toList()));
            }
            return this.annotations;
        }

        public List<Error> getErrors() {
            return this.errors;
        }
    }
}

