/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Set;

class RecursiveRefEvaluator
implements Evaluator {
    private final String ref;

    RecursiveRefEvaluator(JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.ref = node.asString();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        try {
            return ctx.resolveRecursiveRefAndValidate(this.ref, node) ? Evaluator.Result.success() : Evaluator.Result.failure();
        }
        catch (SchemaNotFoundException e) {
            return Evaluator.Result.failure(String.format("Resolution of $recursiveRef [%s] failed", this.ref));
        }
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.CORE_VOCABULARY;
    }
}

