/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PropertiesEvaluator
implements Evaluator {
    private final Map<String, CompoundUri> schemaRefs;

    PropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        HashMap<String, CompoundUri> uris = new HashMap<String, CompoundUri>();
        for (Map.Entry<String, JsonNode> entry : node.asObject().entrySet()) {
            uris.put(entry.getKey(), ctx.getCompoundUri(entry.getValue()));
        }
        this.schemaRefs = Collections.unmodifiableMap(uris);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        HashSet<String> processed = new HashSet<String>();
        boolean valid = true;
        for (Map.Entry<String, JsonNode> entry : node.asObject().entrySet()) {
            CompoundUri ref = this.schemaRefs.get(entry.getKey());
            if (ref == null) continue;
            processed.add(entry.getKey());
            valid = ctx.resolveInternalRefAndValidate(ref, entry.getValue()) && valid;
        }
        return valid ? Evaluator.Result.success(Collections.unmodifiableSet(processed)) : Evaluator.Result.failure();
    }
}

