/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class OneOfEvaluator
implements Evaluator {
    private final List<CompoundUri> refs;

    OneOfEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.refs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getCompoundUri).collect(Collectors.toList()));
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        ArrayList<Integer> matchedIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.refs.size(); ++i) {
            if (!ctx.resolveInternalRefAndValidate(this.refs.get(i), node)) continue;
            matchedIndexes.add(i);
        }
        if (matchedIndexes.size() == 1) {
            return Evaluator.Result.success();
        }
        if (matchedIndexes.isEmpty()) {
            return Evaluator.Result.failure("Value does not match against any of the schemas");
        }
        return Evaluator.Result.failure(String.format("Value matches against more than one schema. Matched schema indexes %s", matchedIndexes));
    }
}

