/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidatingEvaluator;
import java.math.BigDecimal;

class ExclusiveMinimumEvaluator
implements ValidatingEvaluator {
    private final BigDecimal min;

    ExclusiveMinimumEvaluator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.min = node.asNumber();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return Evaluator.Result.success();
        }
        if (node.asNumber().compareTo(this.min) > 0) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(String.format("%s is less than or equal to %s", node.asNumber(), this.min));
    }
}

