/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collections;
import java.util.Set;

public interface Evaluator {
    public Result evaluate(EvaluationContext var1, JsonNode var2);

    default public int getOrder() {
        return 0;
    }

    default public Set<String> getVocabularies() {
        return Collections.emptySet();
    }

    public static final class Result {
        private static final Result SUCCESSFUL_RESULT = new Result(true, null, null);
        private static final Result FAILED_RESULT = new Result(false, null, null);
        private final boolean valid;
        private final Object annotation;
        private final String error;

        private Result(boolean valid, Object annotation, String error) {
            this.valid = valid;
            this.annotation = annotation;
            this.error = error;
        }

        public static Result success() {
            return SUCCESSFUL_RESULT;
        }

        public static Result success(Object annotation) {
            return new Result(true, annotation, null);
        }

        public static Result failure() {
            return FAILED_RESULT;
        }

        public static Result failure(String message) {
            return new Result(false, null, message);
        }

        boolean isValid() {
            return this.valid;
        }

        Object getAnnotation() {
            return this.annotation;
        }

        String getError() {
            return this.error;
        }
    }
}

