/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class AdditionalItemsEvaluator
implements Evaluator {
    private static final Set<String> vocabularies = Collections.singleton("https://json-schema.org/draft/2019-09/vocab/applicator");
    private final CompoundUri schemaRef;

    AdditionalItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Set<String> getVocabularies() {
        return vocabularies;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> array = node.asArray();
        Optional<Object> itemsAnnotation = ctx.getSiblingAnnotation("items", node.getJsonPointer());
        boolean shouldSkip = itemsAnnotation.map(Boolean.class::isInstance).orElse(false);
        if (shouldSkip) {
            return Evaluator.Result.success(true);
        }
        int itemsSize = itemsAnnotation.filter(Integer.class::isInstance).map(Integer.class::cast).orElse(array.size());
        int size = Math.max(array.size() - itemsSize, 0);
        boolean valid = array.stream().skip(itemsSize).filter(element -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)element)).count() == (long)size;
        return valid ? Evaluator.Result.success(true) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

