/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.tools.keygen;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.util.Base64;
import dev.fitko.fitconnect.api.domain.crypto.JWKPair;
import dev.fitko.fitconnect.core.crypto.utils.CertUtils;
import dev.fitko.fitconnect.core.crypto.utils.KeyGenerator;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.UUID;

public final class TestKeyBuilder {
    public static final int DEFAULT_KEY_SIZE = 4096;
    public static final Duration CERT_VALIDITY = Duration.ofDays(365L);

    private TestKeyBuilder() {
    }

    public static JWKPair generateEncryptionKeyPair(int keySize) {
        String keyId = UUID.randomUUID().toString();
        JWEAlgorithm encryptionAlgorithm = JWEAlgorithm.RSA_OAEP_256;
        KeyPair keyPair = KeyGenerator.buildRSAKeyPair(keySize);
        List<Base64> x509CertChain = TestKeyBuilder.buildX509CertificateChain(keyPair);
        JWK publicEncryptionKey = KeyGenerator.buildJWK(keyPair, keyId, KeyOperation.WRAP_KEY, (Algorithm)encryptionAlgorithm, x509CertChain);
        JWK privateDecryptionKey = KeyGenerator.buildJWK(keyPair, keyId, KeyOperation.UNWRAP_KEY, (Algorithm)encryptionAlgorithm);
        return new JWKPair(publicEncryptionKey.toPublicJWK(), privateDecryptionKey);
    }

    public static JWKPair generateEncryptionKeyPair() {
        return TestKeyBuilder.generateEncryptionKeyPair(4096);
    }

    public static JWKPair generateSignatureKeyPair(int keySize) {
        String keyId = UUID.randomUUID().toString();
        JWSAlgorithm signingAlgorithm = JWSAlgorithm.PS512;
        KeyPair keyPair = KeyGenerator.buildRSAKeyPair(keySize);
        List<Base64> x509CertChain = TestKeyBuilder.buildX509CertificateChain(keyPair);
        JWK publicSignatureVerificationKey = KeyGenerator.buildJWK(keyPair, keyId, KeyOperation.VERIFY, (Algorithm)signingAlgorithm, x509CertChain);
        JWK privateSignatureKey = KeyGenerator.buildJWK(keyPair, keyId, KeyOperation.SIGN, (Algorithm)signingAlgorithm);
        return new JWKPair(publicSignatureVerificationKey.toPublicJWK(), privateSignatureKey);
    }

    public static JWKPair generateSignatureKeyPair() {
        return TestKeyBuilder.generateSignatureKeyPair(4096);
    }

    private static List<Base64> buildX509CertificateChain(KeyPair keyPair) {
        X509Certificate certificate = CertUtils.generateX509Certificate(keyPair, CERT_VALIDITY);
        try {
            return List.of(Base64.encode((byte[])certificate.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

