/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.tools.keygen;

import com.nimbusds.jose.jwk.JWK;
import dev.fitko.fitconnect.api.config.defaults.Environments;
import dev.fitko.fitconnect.api.domain.crypto.JWKPair;
import dev.fitko.fitconnect.api.exceptions.FitConnectException;
import dev.fitko.fitconnect.tools.keygen.KeyWriterSettings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class KeyWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyWriter.class);
    static final String PUBLIC_ENCRYPTION_KEY_NAME = "publicKey_encryption.json";
    static final String PUBLIC_ENCRYPTION_KEY_DESC = "Encryption Public Key (key_use=wrapKey)";
    static final String PRIVATE_DECRYPTION_KEY_NAME = "privateKey_decryption.json";
    static final String PRIVATE_DECRYPTION_KEY_DESC = "Decryption Private Key (key_use=unwrapKey)";
    static final String PUBLIC_SIGNATURE_VERIFICATION_KEY_NAME = "publicKey_signature_verification.json";
    static final String PUBLIC_SIGNATURE_VERIFICATION_KEY_DESC = "Signature Verification Public Key (key_use=verify)";
    static final String PRIVATE_SIGNING_KEY_NAME = "privateKey_signing.json";
    static final String PRIVATE_SIGNING_KEY_DESC = "Signing Private Key (key_use=sign)";
    static final String CONFIG_YML_FILE_NAME = "config.yml";
    static final String TEMP_DIR_NAME = "testJWKs";

    public static void writeKeys(KeyWriterSettings settings) {
        Path dir = KeyWriter.getKeyDirectory(settings.getOutputDir());
        LOGGER.info("Writing keys to directory {}", (Object)dir);
        JWKPair encryptionKeyPair = settings.getEncryptionKeyPair();
        JWKPair signatureKeyPair = settings.getSignatureKeyPair();
        KeyWriter.writeKeyToFile(dir, PUBLIC_ENCRYPTION_KEY_NAME, PUBLIC_ENCRYPTION_KEY_DESC, encryptionKeyPair.getPublicKey());
        KeyWriter.writeKeyToFile(dir, PRIVATE_DECRYPTION_KEY_NAME, PRIVATE_DECRYPTION_KEY_DESC, encryptionKeyPair.getPrivateKey());
        KeyWriter.writeKeyToFile(dir, PUBLIC_SIGNATURE_VERIFICATION_KEY_NAME, PUBLIC_SIGNATURE_VERIFICATION_KEY_DESC, signatureKeyPair.getPublicKey());
        KeyWriter.writeKeyToFile(dir, PRIVATE_SIGNING_KEY_NAME, PRIVATE_SIGNING_KEY_DESC, signatureKeyPair.getPrivateKey());
        if (settings.isCreateConfigYaml()) {
            KeyWriter.writeConfigYamlToFile(dir);
        }
    }

    private static Path getKeyDirectory(Path outputDir) {
        if (outputDir != null) {
            return outputDir.toAbsolutePath();
        }
        try {
            return Files.createTempDirectory(TEMP_DIR_NAME, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FitConnectException(e.getMessage(), e);
        }
    }

    private static void writeConfigYamlToFile(Path dir) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("senderConfig", Map.of("clientSecret", "", "clientId", ""));
        data.put("subscriberConfig", Map.of("clientSecret", "", "clientId", "", "privateDecryptionKeyPaths", List.of(dir.resolve(PRIVATE_DECRYPTION_KEY_NAME).toAbsolutePath().toString()), "privateSigningKeyPath", dir.resolve(PRIVATE_SIGNING_KEY_NAME).toAbsolutePath().toString()));
        data.put("activeEnvironment", Environments.TEST.getEnvironmentName().getName());
        DumperOptions options = new DumperOptions();
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        StringWriter writer = new StringWriter();
        Yaml yaml = new Yaml(options);
        yaml.dump(data, (Writer)writer);
        writer.flush();
        KeyWriter.writeFile(dir.resolve(CONFIG_YML_FILE_NAME), writer.toString());
        LOGGER.info("Wrote config.yml");
    }

    private static void writeKeyToFile(Path dir, String filename, String desc, JWK jwk) {
        KeyWriter.writeFile(dir.resolve(filename), jwk.toJSONString());
        LOGGER.info("Wrote {} as {}", (Object)desc, (Object)filename);
    }

    private static void writeFile(Path path, String content) {
        try {
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FitConnectException(e.getMessage(), e);
        }
    }

    @Generated
    private KeyWriter() {
    }
}

