/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.zbp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.config.ZBPCertConfig;
import dev.fitko.fitconnect.api.config.defaults.ZBPEnvironment;
import dev.fitko.fitconnect.api.domain.zbp.ZBPEnvelope;
import dev.fitko.fitconnect.api.domain.zbp.attachment.ZBPApiAttachment;
import dev.fitko.fitconnect.api.domain.zbp.message.CreateMessageResponse;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.core.crypto.utils.CertUtils;
import dev.fitko.fitconnect.core.zbp.TokenGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class ZBPApiService {
    public static final String MAILBOX_MESSAGE_PATH = "/v6/mailbox/messages";
    public static final String CREATE_STATE_PATH = "/v6/mailbox/applications/states";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpClient httpClient;
    private final String baseUrl;
    private final ZBPEnvironment environment;
    private final ZBPCertConfig certConfig;

    public ZBPApiService(HttpClient httpClient, ZBPEnvironment environment, ZBPCertConfig certConfig) {
        this.httpClient = httpClient;
        this.baseUrl = environment.getBaseUrl();
        this.environment = environment;
        this.certConfig = certConfig;
    }

    public CreateMessageResponse sendMessageToMailbox(RSAKey signingKey, String signer, ZBPEnvelope envelope, List<ZBPApiAttachment> attachments) throws RestApiException {
        String url = String.format(this.baseUrl + MAILBOX_MESSAGE_PATH, new Object[0]);
        try {
            String token = TokenGenerator.buildToken(signingKey, signer);
            Map<String, String> headers = this.buildHeaders(token, "multipart/form-data");
            MultipartBody multipartBody = this.buildMultipartBody(envelope, attachments);
            return this.httpClient.put(url, headers, multipartBody, CreateMessageResponse.class).getBody();
        }
        catch (Exception e) {
            throw new RestApiException("Could not send message to zbp mailbox", e);
        }
    }

    public void createNewState(RSAKey signingKey, String signer, ZBPEnvelope createStateEnvelope) throws RestApiException {
        String url = String.format(this.baseUrl + CREATE_STATE_PATH, new Object[0]);
        try {
            String token = TokenGenerator.buildToken(signingKey, signer);
            Map<String, String> headers = this.buildHeaders(token, "application/json");
            this.httpClient.post(url, headers, createStateEnvelope, Void.class);
        }
        catch (Exception e) {
            throw new RestApiException("Could not create application state", e);
        }
    }

    private MultipartBody buildMultipartBody(ZBPEnvelope messageEnvelope, List<ZBPApiAttachment> attachments) {
        MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("json", this.writeToString(messageEnvelope));
        for (ZBPApiAttachment attachment : attachments) {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)attachment.getMimeType()), (byte[])attachment.getData());
            multipartBodyBuilder.addFormDataPart("files", attachment.getFilename(), requestBody);
        }
        return multipartBodyBuilder.build();
    }

    private Map<String, String> buildHeaders(String bearerToken, String contentType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + bearerToken);
        headers.put("Content-Type", contentType);
        if (this.environment.isSendCertAsCookie()) {
            headers.put("Cookie", "AL_ENV_SSL_CLIENT_CERT=" + CertUtils.removeMarker(this.certConfig.getClientCertificate()));
        }
        return headers;
    }

    private String writeToString(ZBPEnvelope envelope) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)envelope);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

