/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.zbp;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import lombok.Generated;

public final class TokenGenerator {
    public static final int VALIDITY_IN_MINUTES = 30;
    public static final List<String> DEFAULT_ROLES = List.of("THIRD_PARTY");

    public static String buildToken(RSAKey signingKey, String signer) {
        JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.RS512).type(JOSEObjectType.JWT).build();
        Instant issueTime = Instant.now();
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().issueTime(Date.from(issueTime)).expirationTime(Date.from(issueTime.plus(30L, ChronoUnit.MINUTES))).claim("signer", (Object)signer).claim("roles", DEFAULT_ROLES).build();
        SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
        try {
            RSASSASigner rsassaSigner = new RSASSASigner(signingKey);
            signedJWT.sign((JWSSigner)rsassaSigner);
            return signedJWT.serialize();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    private TokenGenerator() {
    }
}

