/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.xml;

import dev.fitko.fitconnect.api.domain.model.event.problems.data.DataSchemaViolation;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.services.schema.XMLSchemaLoader;
import dev.fitko.fitconnect.core.validation.xml.AllowedSchemaPatterns;
import dev.fitko.fitconnect.core.validation.xml.InMemoryResourceResolver;
import dev.fitko.fitconnect.core.validation.xml.SchemaSystemIdExtractor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlSchemaValidator.class);
    private final SchemaFactory schemaFactory;
    private final XMLSchemaLoader xmlSchemaLoader;

    public XmlSchemaValidator(XMLSchemaLoader xmlSchemaLoader) {
        this.xmlSchemaLoader = xmlSchemaLoader;
        this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public ValidationResult validate(byte[] xmlData, URI schemaURI) {
        if (AllowedSchemaPatterns.cannotBeValidated(schemaURI)) {
            LOGGER.info("XML schema validation was skipped, no valid urn-schema was found. Allowed is {}", (Object[])AllowedSchemaPatterns.values());
            return ValidationResult.ok();
        }
        try {
            LOGGER.info("Validating XML against schema {}", (Object)schemaURI);
            Map<String, byte[]> entries = this.xmlSchemaLoader.loadSchemas(schemaURI);
            entries.keySet().forEach(s -> LOGGER.debug("Loaded schema {}", s));
            InMemoryResourceResolver resolver = new InMemoryResourceResolver(entries);
            String systemId = SchemaSystemIdExtractor.extractSystemId(xmlData);
            byte[] rootBytes = resolver.getBytesForSystemId(systemId);
            if (rootBytes == null) {
                return ValidationResult.error("Root XSD '" + systemId + "' could not be resolved in xml validation");
            }
            StreamSource rootSource = new StreamSource(new ByteArrayInputStream(rootBytes));
            rootSource.setSystemId(systemId);
            this.schemaFactory.setResourceResolver(resolver);
            Schema schema = this.schemaFactory.newSchema(rootSource);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new ByteArrayInputStream(xmlData)));
        }
        catch (IOException | RuntimeException | SAXException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ValidationResult.withErrorAndProblem(e, new DataSchemaViolation());
        }
        return ValidationResult.ok();
    }
}

