/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.xml;

import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.api.services.http.HttpResponse;
import dev.fitko.fitconnect.api.services.schema.XMLSchemaLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XRepoSchemaLoader
implements XMLSchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XRepoSchemaLoader.class);
    private static final String XOEV_SCHEMA_URL = "https://www.xrepository.de/api/version_standard/%s/xmlschema";
    private static final Map<String, String> REQUEST_HEADER = Map.of("Accept", "application/zip");
    private final HttpClient httpClient;

    public XRepoSchemaLoader(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Map<String, byte[]> loadSchemas(URI schemaUri) throws RestApiException {
        this.validateURIPattern(schemaUri);
        String schemaUrl = String.format(XOEV_SCHEMA_URL, schemaUri);
        LOGGER.info("Requesting XML schemas from {} ", (Object)schemaUrl);
        HttpResponse<InputStream> httpResponse = this.httpClient.get(schemaUrl, REQUEST_HEADER, InputStream.class);
        return this.extractZipEntries(httpResponse.getBody());
    }

    Map<String, byte[]> extractZipEntries(InputStream zippedFiles) {
        HashMap<String, byte[]> hashMap;
        ZipInputStream zipInputStream = new ZipInputStream(zippedFiles);
        try {
            ZipEntry zipEntry;
            HashMap<String, byte[]> schemaDefinitions = new HashMap<String, byte[]>();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    LOGGER.debug("Skipping directory entry {}", (Object)zipEntry.getName());
                    continue;
                }
                try (ByteArrayOutputStream schemaStream = new ByteArrayOutputStream();){
                    zipInputStream.transferTo(schemaStream);
                    byte[] bytes = schemaStream.toByteArray();
                    LOGGER.debug("Unzipped {}", (Object)zipEntry.getName());
                    schemaDefinitions.put(zipEntry.getName(), bytes);
                }
            }
            hashMap = schemaDefinitions;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Extracting zipped schema files failed", (Throwable)e);
                throw new UncheckedIOException("Extracting zipped schema files failed", e);
            }
        }
        zipInputStream.close();
        return hashMap;
    }

    private void validateURIPattern(URI schemaUri) {
        if (!ApplicationConfig.LEIKA_KEY_PATTERN.matcher(schemaUri.toString()).matches()) {
            throw new RuntimeException("URI '" + String.valueOf(schemaUri) + "' does not match required pattern. See " + String.valueOf(ApplicationConfig.LEIKA_KEY_PATTERN));
        }
    }
}

