/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.xml;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SchemaSystemIdExtractor {
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String ATTR_SCHEMA_LOCATION = "schemaLocation";
    private static final String ATTR_NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";

    private SchemaSystemIdExtractor() {
    }

    public static String extractSystemId(byte[] xmlBytes) {
        if (xmlBytes == null || xmlBytes.length == 0) {
            return "";
        }
        try {
            Document document = SchemaSystemIdExtractor.parseXml(xmlBytes);
            Element root = document.getDocumentElement();
            if (root == null) {
                return "";
            }
            String rootNamespace = SchemaSystemIdExtractor.trim(root.getNamespaceURI());
            String systemId = SchemaSystemIdExtractor.extractFromSchemaLocation(root, rootNamespace);
            if (systemId != null) {
                return systemId;
            }
            return SchemaSystemIdExtractor.extractFromNoNamespaceSchemaLocation(root);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Document parseXml(byte[] xmlBytes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);){
            Document document = builder.parse(inputStream);
            return document;
        }
    }

    private static String extractFromNoNamespaceSchemaLocation(Element root) {
        String value = root.getAttributeNS(XSI_NS, ATTR_NO_NAMESPACE_SCHEMA_LOCATION);
        String trimmed = SchemaSystemIdExtractor.trim(value);
        return trimmed == null ? "" : trimmed;
    }

    private static String extractFromSchemaLocation(Element root, String rootNamespace) {
        String schemaLocation = SchemaSystemIdExtractor.trim(root.getAttributeNS(XSI_NS, ATTR_SCHEMA_LOCATION));
        if (schemaLocation == null) {
            return null;
        }
        String[] tokens = schemaLocation.split("\\s+");
        if (tokens.length < 2) {
            return null;
        }
        String firstSystemId = null;
        int i = 0;
        while (i + 1 < tokens.length) {
            String ns = SchemaSystemIdExtractor.trim(tokens[i]);
            String loc = SchemaSystemIdExtractor.trim(tokens[i + 1]);
            if (loc != null) {
                if (firstSystemId == null) {
                    firstSystemId = loc;
                }
                if (rootNamespace != null && rootNamespace.equals(ns)) {
                    return loc;
                }
            }
            i += 2;
        }
        return firstSystemId;
    }

    private static String trim(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }
}

