/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class InMemoryResourceResolver
implements LSResourceResolver {
    private final Map<String, byte[]> entries;

    InMemoryResourceResolver(Map<String, byte[]> entries) {
        this.entries = entries;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId == null) {
            return null;
        }
        byte[] data = this.getBytesForSystemId(systemId);
        if (data == null) {
            return null;
        }
        return new InMemoryLSInput(publicId, systemId, data);
    }

    byte[] getBytesForSystemId(String systemId) {
        byte[] bytes = this.entries.get(systemId);
        if (bytes != null) {
            return bytes;
        }
        return this.entries.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith(systemId)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    private static final class InMemoryLSInput
    implements LSInput {
        private String publicId;
        private String systemId;
        private String baseURI;
        private String encoding = StandardCharsets.UTF_8.name();
        private boolean certifiedText;
        private byte[] data;

        InMemoryLSInput(String publicId, String systemId, byte[] data) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.data = Objects.requireNonNull(data, "data must not be null");
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            try {
                this.data = byteStream.readAllBytes();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public String getStringData() {
            return new String(this.data, Charset.forName(this.encoding));
        }

        @Override
        public void setStringData(String stringData) {
            this.data = stringData.getBytes(Charset.forName(this.encoding));
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            if (encoding != null) {
                this.encoding = encoding;
            }
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }
    }
}

